<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_AuthDB.php,v 1.1 2009/01/11 05:34:31 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * DBクラス
 */
require_once SYL_FRAMEWORK_DIR . '/lib/SyL_DB.php';

/**
 * DB認証クラス
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_AuthDB.php,v 1.1 2009/01/11 05:34:31 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_AuthDB extends SyL_Auth
{
    /**
     * ログイン認証実行
     * 
     * @access public
     * @return bool OK: 認証OK, NG: 認証NG
     */
    function doLogin()
    {
        list($id, $passwd) = $this->getLoginParameterName();
        $client_username = isset($_POST[$id])     ? $_POST[$id]     : '';
        $client_password = isset($_POST[$passwd]) ? $_POST[$passwd] : '';

        $parameters = explode(':', SYL_AUTH_TYPE_PARAMETER, 4);
        if (!isset($parameters[3])) $parameters[3] = '';

        $conn =& SyL_DB::getConnection();

        SyL_Loggers::info("Table: {$parameters[0]} Column(ID): {$parameters[1]} Column(Password): {$parameters[2]}");

        $sql  = "";
        $sql .= "SELECT ";
        $sql .=   $parameters[2] . " ";
        $sql .= "FROM ";
        $sql .=   $parameters[0] . " ";
        $sql .= "WHERE ";
        $sql .=   $parameters[1] . " = '" . $conn->escape($client_username) . "' ";
        if ($parameters[3]) {
        $sql .=   " AND " . $parameters[3] . " ";
        }

        $conn->queryRef($sql, $server_password, 'one');

        // パスワード判定
        return $this->isLoginPassword($client_username, $client_password, $server_password);
    }
}
