<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ConfigComponents.php,v 1.1 2009/01/11 05:34:32 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * コンポーネント設定ファイルを読み込むクラス
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ConfigComponents.php,v 1.1 2009/01/11 05:34:32 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_ConfigComponents extends SyL_Config
{
    /**
     * 設定ファイル名
     * 
     * @access private
     * @var string
     */
    var $config_file_name = 'components.xml';
    /**
     * イベント名
     * 
     * @access protected
     * @var string
     */
    var $event = 'initStream';
    /**
     * デフォルト実行順序
     * 
     * @access protected
     * @param int
     */
    var $default_priority = 3;

    /**
     * 設定ファイルをセット
     *
     * @access protected
     */
    function setProjectConfigFiles()
    {
        // プロジェクトコンポーネント設定ファイル
        $this->file_names[] = SYL_PROJECT_CONFIG_DIR . "/{$this->config_file_name}";
    }

    /**
     * XMLファイルの解析処理
     *
     * @access public
     * @param bool キャッシュ有効フラグ
     */
    function parseXml($enable_cache=true)
    {
        if (SYL_CACHE && $enable_cache) {
            // キャッシュを使用する
            $key = SYL_PROJECT_DIR;
            if ($cache =& $this->getCache($key)) {
                // キャッシュが取得できなかった場合（キャッシュオブジェクトを取得した場合）
                parent::parseXml();
                $cache->write($this->config);
            }
        } else {
            // キャッシュを使用しない
            parent::parseXml();
        }
    }

    /**
     * XMLデータ内容取得ハンドラメソッド
     * ※オーバーライド
     *
     * @access protected
     * @param string 現在XML解析中のパス
     * @param string XMLのタグの属性値
     * @param string XMLのタグの値
     */
    function getElement($current_path, $attribute, $text)
    {
        static $name  = '';
        static $event = '';
        static $method_name = '';

//echo $current_path . "<br>";

        // XML解析結果を取得
        switch ($current_path) {
        case '/syl-components/component':
            if (isset($attribute['enable']) && ($attribute['enable'] === 'false')) {
                $name = '';
                return;
            }
            $name = $attribute['name'];
            $this->config[$name]['type']      = 'component';
            $this->config[$name]['class']     = isset($attribute['class'])  ? $attribute['class']  : $name;
            $this->config[$name]['file']      = $attribute['file'];
            $this->config[$name]['reference'] = (isset($attribute['reference']) && ($attribute['reference'] === 'true'));
            // 実行順序
            $this->config[$name]['priority'] = isset($attribute['priority']) ? (int)$attribute['priority'] : $this->default_priority;
            // コンストラクタインジェクションフラグ
            $this->config[$name]['constructor'] = false;
            // ファイルが存在しないとエラーのフラグ
            $this->config[$name]['force'] = false;
            // イベントタグ
            $event = isset($attribute['event']) ? $attribute['event'] : $this->event;
            $this->config[$name]['event'][$event][] = $name;
            // 引数
            $this->config[$name]['args'] = array();
            break;

        default:
            if (!$name) return;

            switch ($current_path) {
            case '/syl-components/component/constructor':
                $method_name = 'constructor:' . (isset($attribute['static']) ? $attribute['static'] : '');
                // コンストラクタインジェクションフラグ
                $this->config[$name]['constructor'] = true;
                // イベントタグ
                $event = isset($attribute['event']) ? $attribute['event'] : $event;
                // コンストラクタインジェクションの場合、元のメソッドは削除
                $index = array_search($name, $this->config[$name]['event'][$event]);
                if ($index !== false) {
                    unset($this->config[$name]['event'][$event][$index]);
                }
                $this->config[$name]['event'][$event][] = $method_name;
                $this->config[$name]['args'][$method_name] = array();
                break;

            case '/syl-components/component/setter':
                // ダイレクトセットタグ
                if (isset($attribute['direct']) && ($attribute['direct'] === 'true')) {
                    $method_name = 'setter:' . $attribute['name'] . ':true';
                } else {
                    $method_name = 'setter:set' . ucfirst(strtolower($attribute['name'])) . ':false';
                }
                // イベントタグ
                $event = isset($attribute['event']) ? $attribute['event'] : $event;
                $this->config[$name]['event'][$event][] = $method_name;
                $this->config[$name]['args'][$method_name] = array();
                break;

            case '/syl-components/component/method':
                $method_name = 'method:' . $attribute['name'];
                // イベントタグ
                $event = isset($attribute['event']) ? $attribute['event'] : $event;
                $this->config[$name]['event'][$event][] = $method_name;
                $this->config[$name]['args'][$method_name] = array();
                break;

            case '/syl-components/component/constructor/arg':
            case '/syl-components/component/setter/arg':
            case '/syl-components/component/method/arg':
                $type = isset($attribute['type']) ? $attribute['type'] : 'value';
                $ref  = (isset($attribute['reference']) && ($attribute['reference'] === 'true')) ? 'true' : 'false';
                $this->config[$name]['args'][$method_name][] = "{$type}:{$ref}:{$text}";
                break;
            }
        }
    }
}
