<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ConfigFilters.php,v 1.1 2009/01/11 05:34:32 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * フィルタ設定ファイルを読み込むクラス
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ConfigFilters.php,v 1.1 2009/01/11 05:34:32 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_ConfigFilters extends SyL_Config
{
    /**
     * 設定ファイル名
     * 
     * @access private
     * @var string
     */
    var $config_file_name = 'filters.xml';
    /**
     * イベント名
     * 
     * @access protected
     * @var string
     */
    var $event = 'loadStream';
    /**
     * デフォルト実行順序
     *
     * @access protected
     * @param int
     */
    var $default_priority = 2;
    /**
     * フィルタイベント（アクション前）
     * 
     * @access private
     * @var string
     */
    var $filter_event_pre_action = 'loadStream';
    /**
     * フィルタイベント（アクション後）
     * 
     * @access private
     * @var string
     */
    var $filter_event_post_action = 'middleStream';
    /**
     * フィルタイベント（ビュー表示前）
     * 
     * @access private
     * @var string
     */
    var $filter_event_pre_render = 'renderStream';
    /**
     * フィルタイベント（ビュー表示後）
     * 
     * @access private
     * @var string
     */
    var $filter_event_post_render = 'unloadStream';

    /**
     * 設定ファイルをセット
     *
     * @access protected
     */
    function setProjectConfigFiles()
    {
        // アプリケーションフィルタ設定ファイル
        $config = SYL_APP_CONFIG_DIR . "/{$this->config_file_name}";
        if (is_file($config)) {
            $this->file_names[] = $config;
        }
        // プロジェクトフィルタ設定ファイル
        $config = SYL_PROJECT_CONFIG_DIR . "/{$this->config_file_name}";
        if (is_file($config)) {
            $this->file_names[] = $config;
        }
    }

    /**
     * XMLファイルの解析処理
     *
     * @access public
     * @param bool キャッシュ有効フラグ
     */
    function parseXml($enable_cache=true)
    {
        if (count($this->file_names) > 0) {
            if (SYL_CACHE && $enable_cache) {
                // キャッシュを使用する
                $key = SYL_APP_DIR . $this->router->getActionFile();
                $cache =& $this->getCache($key);
                if ($cache) {
                    // キャッシュが取得できなかった場合（キャッシュオブジェクトを取得した場合）
                    parent::parseXml();
                    $cache->write($this->config);
                }
            } else {
                // キャッシュを使用しない
                parent::parseXml();
            }
        }
    }

    /**
     * XMLデータ内容取得ハンドラメソッド
     * ※オーバーライド
     *
     * @access protected
     * @param string 現在XML解析中のパス
     * @param string XMLのタグの属性値
     * @param string XMLのタグの値
     */
    function getElement($current_path, $attribute, $text)
    {
        static $name = '';
        static $method_name = '';

//echo $current_path . "<br>";

        // XML解析結果を取得
        switch ($current_path) {
        case '/syl-filters/filter':
            if (isset($attribute['enable']) && ($attribute['enable'] === 'false')) {
                $name = '';
                return;
            }

            // アクセスアクション名確認
            $reg = isset($attribute['path']) ? str_replace('/', '\\/', $attribute['path']) : '(.*)';
            // アクションファイル取得用ルータオブジェクト
            if (preg_match('/^' . $reg . '$/', '/'.$this->router->getActionFile())) {
                $name = $attribute['name'];
                $this->config[$name]['type']      = 'filter';
                $this->config[$name]['class']     = $attribute['class'];
                $this->config[$name]['file']      = $attribute['file'];
                $this->config[$name]['reference'] = false;
                // 実行順序
                $this->config[$name]['priority'] = $this->default_priority;
                // コンストラクタインジェクションフラグ
                $this->config[$name]['constructor'] = false;
                // ファイルが存在しないとエラーのフラグ
                $this->config[$name]['force'] = false;
                // イベントタグ（オブジェクト作成時）
                $this->config[$name]['event'][$this->event][] = $name;
                // 引数
                $this->config[$name]['args'] = array();
            } else {
                $name = '';
            }
            break;

        default:
            if (!$name) return;

            switch ($current_path) {
            case '/syl-filters/filter/preAction':
               $method_name = 'method:' . (isset($attribute['name']) ? $attribute['name'] : 'preAction');
               $this->config[$name]['event'][$this->filter_event_pre_action][] = $method_name;
               $this->config[$name]['args'][$method_name] = array();
               break;

            case '/syl-filters/filter/postAction':
               $method_name = 'method:' . (isset($attribute['name']) ? $attribute['name'] : 'postAction');
               $this->config[$name]['event'][$this->filter_event_post_action][] = $method_name;
               $this->config[$name]['args'][$method_name] = array();
               break;

            case '/syl-filters/filter/preRender':
               $method_name = 'method:' . (isset($attribute['name']) ? $attribute['name'] : 'preRender');
               $this->config[$name]['event'][$this->filter_event_pre_render][] = $method_name;
               $this->config[$name]['args'][$method_name]  = array();
               break;

            case '/syl-filters/filter/postRender':
               $method_name = 'method:' . (isset($attribute['name']) ? $attribute['name'] : 'postRender');
               $this->config[$name]['event'][$this->filter_event_post_render][] = $method_name;
               $this->config[$name]['args'][$method_name]  = array();
               break;

            case '/syl-filters/filter/preAction/arg':
            case '/syl-filters/filter/postAction/arg':
            case '/syl-filters/filter/preRender/arg':
            case '/syl-filters/filter/postRender/arg':
               $type = isset($attribute['type']) ? $attribute['type'] : 'value';
               $ref  = (isset($attribute['reference']) && ($attribute['reference'] === 'true')) ? 'true' : 'false';
               $this->config[$name]['args'][$method_name][] = "{$type}:{$ref}:{$text}";
               break;
            }
        }
    }
}
