<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Adm.php,v 1.1 2009/01/11 05:34:30 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * 上位レイヤーデータ管理クラス - 共通
 */
require_once SYL_FRAMEWORK_DIR . '/core/Adm/SyL_AdmOperation.php';

/**
 * 上位レイヤーデータ管理作成クラス
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Adm.php,v 1.1 2009/01/11 05:34:30 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_Adm
{
    /**
     * ADM操作オブジェクトを作成する
     *
     * @static
     * @access public
     * @param object アクションフォームオブジェクト
     * @param object DBオブジェクト
     * @param array 主キー配列
     * @return object ADMオブジェクト
     */
    function &factory(&$form, &$conn, $keys=array())
    {
        $classname = 'SyL_AdmOperation' . ucfirst($form->getType());
        $file = SYL_FRAMEWORK_DIR . "/core/Adm/Operation/{$classname}.php";
        if (!is_file($file)) {
            trigger_error("[SyL error] Invalid type (" . $form->getType() . ")", E_USER_ERROR);
        }
        include_once $file;
        $adm =& new $classname($form, $conn, $keys);
        return $adm;
    }
}
