<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Config.php,v 1.1 2009/01/11 05:34:30 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * XML操作クラス
 */
require_once SYL_FRAMEWORK_DIR . '/lib/Xml/SyL_XmlReader.php';
/**
 * キャッシュクラス
 */
require_once SYL_FRAMEWORK_DIR . '/lib/SyL_Cache.php';

/** 
 * 設定ファイルを読み込むクラス
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Config.php,v 1.1 2009/01/11 05:34:30 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_Config extends SyL_XmlReader
{
    /**
     * 設定ファイル名
     * 
     * @access private
     * @var string
     */
    var $config_file_name = '';
    /**
     * イベント名
     * 
     * @access protected
     * @var string
     */
    var $event = '';
    /**
     * デフォルト実行順序
     * 
     * @access protected
     * @var int
     */
    var $default_priority = 5;
    /**
     * XMLファイル名
     * 
     * @access private
     * @var array
     */
    var $file_names = array();
    /**
     * 設定ファイル配列
     * 
     * @access private
     * @var array
     */
    var $config = array();
    /**
     * ルータオブジェクト
     * 
     * @access private
     * @var object
     */
    var $router = null;

    /**
     * コンストラクタ
     *
     * @access public
     */
    function SyL_Config()
    {
        $this->setProjectConfigFiles();
        parent::setClientEncode(SYL_ENCODE_INTERNAL);
    }

    /**
     * 設定ファイルをセット
     *
     * @access protected
     */
    function setProjectConfigFiles()
    {
    }

    /**
     * 設定ファイルオブジェクトを取得
     *
     * @static
     * @access public
     * @param string 設定ファイルオブジェクト名
     * @return object 設定ファイルオブジェクト
     */
    function &factory($config_name)
    {
        $class_name = 'SyL_Config' . ucfirst($config_name);
        include_once SYL_FRAMEWORK_DIR . "/core/Config/{$class_name}.php";
        $obj = new $class_name();
        return $obj;
    }

    /**
     * ルータオブジェクトをセット
     *
     * @access public
     * @param object ルータオブジェクト
     */
    function setRouter(&$router)
    {
        $this->router =& $router;
    }

    /**
     * 設定値を取得
     *
     * @static
     * @access public
     * @param string 設定キー
     */
    function get($name='')
    {
        static $values = null;

        if ($values !== null) {
            if ($name === '') {
                return $values;
            } else {
                return isset($values[$name]) ? $values[$name] : null;
            }
        } else {
            $config =& SyL_Config::factory('defines');
            $config->parseXml();
            $values = $config->getConfig();
        }
    }

    /**
     * キャッシュオブジェクトを取得する
     *
     * @access public
     * @param string キャッシュ接頭辞
     * @param string 追加キー文字列
     * @return object キャッシュオブジェクト
     */
    function &getCache($key)
    {
        // キャッシュを使用する
        $mtime = 0;
        foreach ($this->file_names as $file_name) {
            $mtime_tmp = filemtime($file_name);
            if ($mtime < $mtime_tmp) {
                $mtime = $mtime_tmp;
            }
        }

        $cache =& SyL_Cache::factory('file');
        $cache->setPrefix(SYL_APP_NAME . '.');
        $cache->setKey($key);
        $cache->setMinModifyTime($mtime);
        $cache->setCacheDir(SYL_APP_CACHE_DIR . '/config/' . basename($this->file_names[0]) . '/');

        //$cache->useIncludeCache();

        $this->config = $cache->read();
        if ($this->config) {
            // キャッシュOK
            $cache = null;
            return $cache;
        } else {
            // キャッシュNG
            return $cache;
        }
    }

    /**
     * 複数のXMLファイルを解析する
     *
     * @access public
     * @param bool キャッシュ有効フラグ
     */
    function parseXml($enable_cache=true)
    {
        $config = array();
        foreach ($this->file_names as $file_name) {
            parent::setFile($file_name);
            parent::parseXml();
            if (is_array($this->config)) {
                $config += $this->config;
            }
            // 初期化
            $this->config = array();
        }
        $this->config = $config;
    }

    /**
     * XMLデータ内容取得ハンドラメソッド
     *
     * @access protected
     * @param string 現在XML解析中のパス
     * @param string XMLのタグの属性値
     * @param string XMLのタグの値
     */
    function getElement($current_path, $attribute, $text)
    {
    }

    /**
     * XML設定値を取得
     * 
     * @access public
     * @return array 設定値配列
     */
    function getConfig()
    {
        return $this->config;
    }
}
