<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Request.php,v 1.1 2009/01/11 05:34:30 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * 汎用プロパティクラス
 */
require_once SYL_FRAMEWORK_DIR . '/lib/Util/SyL_UtilProperty.php';

/**
 * リスエストクラス
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Request.php,v 1.1 2009/01/11 05:34:30 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_Request
{
    /**
     * セッションオブジェクト
     * 
     * @access private
     * @var object
     */
    var $session = null;
    /**
     * クッキーオブジェクト
     * 
     * @access private
     * @var object
     */
    var $cookie = null;
    /**
     * ファイルオブジェクト
     * 
     * @access private
     * @var object
     */
    var $files = null;

    /**
     * コンストラクタ
     *
     * @access public
     */
    function SyL_Request()
    {
    }

    /**
     * SyL_Requestクラスのインスタンス取得
     *
     * singletonモデルを採用しているので、
     * 常に1つのインスタンスの参照が取得される。
     *
     * ※取得方法
     *   $SyL_Request =& SyL_Request::singleton();
     *
     * @access public
     */
    function &singleton()
    {
        static $singleton;
        if (!is_object($singleton)) {
            $classname = __CLASS__;
            $singleton = new $classname();
        }
        return $singleton;
    }

    /**
     * セッションオブジェクトを作成
     *
     * @access private
     */
     function createSession()
     {
         $type = '';
         switch (strtolower(SYL_SESSION_TYPE)) {
         case 'db':       $type = 'Db';       break;
         case 'memcache': $type = 'Memcache'; break;
         default:         $type = '';         break;
         }
         $classname = "SyL_RequestSession{$type}";
         include_once SYL_FRAMEWORK_DIR . "/core/Request/{$classname}.php";
         $this->session =& new $classname();
     }

    /**
     * クッキーオブジェクトを作成
     *
     * @access private
     */
     function createCookie()
     {
         include_once SYL_FRAMEWORK_DIR . '/core/Request/SyL_RequestCookie.php';
         $this->cookie =& new SyL_RequestCookie();
     }

    /**
     * アップロードファイルオブジェクトを作成
     *
     * @access private
     */
     function createFile()
     {
         include_once SYL_FRAMEWORK_DIR . '/core/Request/SyL_RequestFile.php';
         $this->files =& new SyL_RequestFile();
     }

    /**
     * セッション値をセット
     * 
     * @access public
     * @param string パラメータ名
     * @param string パラメータ値
     */
    function setSession($name, $value)
    {
        if ($this->session === null) {
            $this->createSession();
        }
        $this->session->set($name, $value);
    }

    /**
     * セッション値を取得
     *
     * @access public
     * @param string パラメータ名
     * @return mixed パラメータ値
     */
    function getSession($name)
    {
        if ($this->session === null) {
            $this->createSession();
        }
        return (($this->session != null) ? $this->session->get($name) : null);
    }

    /**
     * セッションオブジェクトを取得
     *
     * @access public
     * @return array パラメータ値
     */
    function &getSessionObject()
    {
        if ($this->session === null) {
            $this->createSession();
        }
        return $this->session;
    }

    /**
     * クッキー値をセット
     * 
     * @access public
     * @param string パラメータ名
     * @param string パラメータ値
     */
    function setCookie($name, $value)
    {
        if ($this->cookie === null) {
            $this->createCookie();
        }
        $this->cookie->set($name, $value);
    }

    /**
     * クッキー値を取得
     *
     * @access public
     * @param string パラメータ名
     * @return mixed パラメータ値
     */
    function getCookie($name)
    {
        if ($this->cookie === null) {
            $this->createCookie();
        }
        return $this->cookie->get($name);
    }

    /**
     * クッキーオブジェクトを取得
     *
     * @access public
     * @return array パラメータ値
     */
    function &getCookieObject()
    {
        if ($this->cookie === null) {
            $this->createCookie();
        }
        return $this->cookie;
    }

    /**
     * アップロードファイル値を取得
     *
     * @access public
     * @param string パラメータ名
     * @return mixed パラメータ値
     */
    function getFile($name)
    {
        if ($this->files === null) {
            $this->createFile();
        }
        return $this->files->get($name);
    }

    /**
     * アップロードファイルオブジェクトを取得
     *
     * @access public
     * @return array パラメータ値
     */
    function &getFileObject()
    {
        if ($this->files === null) {
            $this->createFile();
        }
        return $this->files;
    }

    /**
     * 環境変数値を取得
     *
     * @access public
     * @param string 環境変数名
     * @return string 環境変数値
     */
    function getServerVer($name)
    {
        return isset($_SERVER[$name]) ? $_SERVER[$name] : null;
    }
}
