<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_View.php,v 1.1 2009/01/11 05:34:30 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * 画面表示クラス
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_View.php,v 1.1 2009/01/11 05:34:30 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_View
{
    /**
     * コンテンツタイプ
     * 
     * @access protected
     * @var string
     */
    var $content_type = '';
    /**
     * コンテンツ容量出力判定
     * 
     * @access protected
     * @var bool
     */
    var $content_length = SYL_RESPONSE_LENGTH;
    /**
     * gzip圧縮判定
     * 
     * @access protected
     * @var bool
     */
    var $gzip_compress = SYL_RESPONSE_GZIP;
    /**
     * 表示内容のデータ
     * 
     * @access protected
     * @var string
     */
    var $render = '';
    /**
     * フレームワーク情報管理クラス
     * 
     * @access protected
     * @var object
     */
    var $context = null;
    /**
     * ルータ管理クラス
     * 
     * @access protected
     * @var object
     */
    var $router = null;
    /**
     * フレームワークデータ保持クラス
     * 
     * @access protected
     * @var object
     */
    var $data = null;

    /**
     * コンストラクタ
     *
     * @access public
     * @param object データ管理オブジェクト
     */
    function SyL_View(&$context, &$data)
    {
        $this->context =& $context;
        $this->data    =& $data;
        $this->router  =& $context->getRouter();
    }

    /**
     * テンプレートオブジェクトを取得
     * 
     * @access public
     * @param object データ管理オブジェクト
     * @param object コンポーネントメソッドオブジェクト
     * @return object ビューオブジェクト
     */
    function &getObject(&$context, &$data)
    {
        $router =& $context->getRouter();

        $view      = null;
        $type      = $router->getViewType();
        $classname = '';
        $classfile = '';

        if (!$type || (SYL_ENV_TYPE == 'cmd')) {
            // Nullビュー
            $classname = 'SyL_ViewNull';
            $classfile = SYL_FRAMEWORK_DIR . "/core/View/{$classname}.php";
        } else {
            $classname = 'SyL_View' . implode('', array_map('ucfirst', explode('.', $type)));
            $classfile = SYL_FRAMEWORK_DIR . "/core/View/{$classname}.php";
        }

        if (!is_file($classfile)) {
            trigger_error("[SyL error] {$type} View file not found ({$classfile})", E_USER_ERROR);
        }

        include_once $classfile;
        $view =& new $classname($context, $data);

        SyL_Loggers::debug("view info env: " . SYL_ENV_TYPE . " type: {$type} class: {$classname} file: {$classfile}");

        return $view;
    }

    /**
     * テンプレートディレクトリルートを取得
     *
     * @access public
     * @return string テンプレートディレクトリルート
     */
    function getTemplateDir()
    {
        return $this->router->getTemplateDir();
    }

    /**
     * テンプレートファイルを取得
     *
     * @access public
     * @return string テンプレートファイル
     */
    function getTemplateFile()
    {
        return $this->router->getTemplateFile();
    }

    /**
     * コンテンツタイプをセット
     * 
     * @access public
     * @param string コンテンツタイプ
     */
    function setContentType($content_type)
    {
        $this->content_type = $content_type;
    }

    /**
     * コンテンツタイプを取得
     * 
     * @access public
     * @return string コンテンツタイプ
     */
    function getContentType()
    {
        return $this->content_type;
    }

    /**
     * コンテンツ容量出力判定
     * 
     * @access public
     * @return bool コンテンツ容量出力判定
     */
    function isContentLength()
    {
        return (bool)$this->content_length;
    }

    /**
     * gzip圧縮判定
     * 
     * @access public
     * @return bool gzip圧縮判定
     */
    function isGzipCompress()
    {
        return (bool)$this->gzip_compress;
    }

    /**
     * アクションパラメータを取得する
     * 
     * @access public
     * @return array ビューに渡すパラメータ
     */
    function &getActionValues()
    {
        $values  = array();
        $values += $this->context->getParameters();
        $values += $this->data->finalOutputs();

        return $values;
    }

    /**
     * 表示内容をセット
     * 
     * @access protected
     * @param string 表示内容
     */
    function setRender(&$render)
    {
        $this->render =& $render;
    }

    /**
     * 表示内容を取得
     * 
     * @access public
     * @return string レンダリングHTML
     */
    function &getRender()
    {
        return $this->render;
    }

    /**
     * HTMLレンダリング実行
     * 
     * @access abstract
     */
    function render()
    {
    }
}
