<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ViewJsLogin.php,v 1.1 2009/01/11 05:34:30 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * 認証クラス
 */
require_once SYL_FRAMEWORK_DIR . '/core/SyL_Auth.php';
/**
 * JavaScriptビュークラス
 */
require_once 'SyL_ViewJs.php';

/**
 * JavaScriptログインビュークラス
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ViewJsLogin.php,v 1.1 2009/01/11 05:34:30 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_ViewJsLogin extends SyL_ViewJs
{
    /**
     * JavaScriptをインポートする
     * 
     * @access public
     */
    function importJs()
    {
        // 認証オブジェクト作成
        $this->auth =& SyL_Auth::singleton();

        list($username, $password) = explode(':', SYL_AUTH_LOGIN_PARAMETER);
        if (SYL_AUTH_PASSWORD_HASH) {
            $this->data->set('login_key',  $this->auth->createChallengeCode());
            $this->data->set('login_hash', 'hex_' . SYL_AUTH_PASSWORD_HASH);
            $this->data->addImport('hash.' . SYL_AUTH_PASSWORD_HASH);
        } else {
            $this->data->set('login_key',  '');
            $this->data->set('login_hash', 'null');
        }
        $this->data->addImport('login');
        $this->data->set('login_username', $username);
        $this->data->set('login_password', $password);
    }

}
