<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ViewLayout.php,v 1.1 2009/01/11 05:34:30 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * レイアウトビュークラス
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ViewLayout.php,v 1.1 2009/01/11 05:34:30 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_ViewLayout extends SyL_View
{
    /**
     * レイアウト設定ファイル配列
     * 
     * @access private
     * @var array
     */
    var $config = array();

    /**
     * コンストラクタ
     *
     * @access public
     * @param object コンテキストオブジェクト
     * @param object データ管理オブジェクト
     */
    function SyL_ViewLayout(&$context, &$data)
    {
        parent::SyL_View($context, $data);

        $config =& SyL_Config::factory('layouts');
        $config->setRouter($context->getRouter());
        $config->parseXml();
        $this->config = $config->getConfig();

        // テンプレートパス補正
        if ($this->config['file'][0] == '/') {
            $this->config['file'] = substr($this->config['file'], 1);
        }

        // コンテンツタイプをセット
        $this->setContentType('text/html; charset=' . SYL_ENCODE_INTERNAL);
    }

    /**
     * レイアウトファイルを取得
     * 
     * @access public
     * @return string テンプレートファイル
     */
    function getLayoutFile()
    {
        return $this->config['file'];
    }

    /**
     * 部分テンプレートファイルを取得
     * 
     * @access public
     * @return array 部分テンプレートファイル
     */
    function getTemplateFiles()
    {
        return $this->config['templates'];
    }

    /**
     * コンテンツファイルを取得
     * 
     * @access public
     * @return string コンテンツファイル
     */
    function getContentFile()
    {
        return $this->router->getTemplateFile();
    }

    /**
     * アクションパラメータを取得する
     * 
     * @access public
     * @return array ビューに渡すパラメータ
     */
    function &getActionValues()
    {
        $values =& parent::getActionValues();

        // レイアウト設定値
        if (isset($this->config['templates'])) {
            $values += $this->getTemplateFiles();
        }
        if (isset($this->config['content']) && $this->config['content']) {
            $values[$this->config['content']] = $this->getContentFile();
        } else {
            SyL_Loggers::notice("Content context not found");
        }
        if (isset($this->config['params'])) {
            $values += $this->config['params'];
        }

        return $values;
    }
}
