<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ViewLayoutDefault.php,v 1.1 2009/01/11 05:34:30 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * レイアウトビュークラス
 */
require_once 'SyL_ViewLayout.php';

/**
 * デフォルトレイアウトビュークラス
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ViewLayoutDefault.php,v 1.1 2009/01/11 05:34:30 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_ViewLayoutDefault extends SyL_ViewLayout
{
    /**
     * レイアウトファイルを絶対パスに変換してから取得
     * 
     * @access public
     * @return string テンプレートファイル
     */
    function getLayoutFile()
    {
        return $this->router->getTemplateDir() . $this->config['file'];
    }

    /**
     * 部分テンプレートファイルを絶対パスに変換してから取得
     * 
     * @access public
     * @return array 部分テンプレートファイル
     */
    function getTemplateFiles()
    {
        $template_files = array();
        foreach ($this->config['templates'] as $name => $value) {
            $template_files[$name] = $this->router->getTemplateDir() . $value;
        }
        return $template_files;
    }

    /**
     * コンテンツファイルを絶対パスに変換してから取得
     * 
     * @access public
     * @return string コンテンツファイル
     */
    function getContentFile()
    {
        return $this->router->getTemplateDir() . $this->router->getTemplateFile();
    }

    /**
     * HTMLレンダリング実行
     * 
     * @access public
     */
    function render()
    {
        // アクションからのパラメータ取得
        $values =& $this->getActionValues();
        foreach (array_keys($values) as $key) {
            if (is_object($values[$key])) {
                $$key =& $values[$key];
            } else {
                $$key = $values[$key];
            }
        }

        // 表示内容をセット
        ob_start();
        include_once $this->getLayoutFile();
        $this->setRender(ob_get_clean());
    }
}
