<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DBSchema.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * DBスキーマ取得クラス
 * 
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DBSchema.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_DBSchema
{
    /**
     * DBオブジェクト
     * 
     * @access protected
     * @var object
     */
    var $conn = null;

    /**
     * コンストラクタ
     *
     * @access public
     * @param object DBオブジェクト
     */
    function SyL_DBSchema(&$conn)
    {
        $this->conn =& $conn;
    }

    /**
     * DBスキーマ取得オブジェクト作成
     *
     * @access public
     * @param object DBオブジェクト
     * @return object DBスキーマ取得オブジェクト
     */
    function &factory(&$conn)
    {
        $type = $conn->getType();
        switch (strtolower($type)) {
        case 'mysql':
        case 'mysqli':
        case 'pdomysql':
            $type = 'Mysql';
            break;
        case 'pgsql':
        case 'pdopgsql':
            $type = 'Pgsql';
            break;
        default:
            trigger_error("[SyL error] Not supported DB type schema ({$type})", E_USER_ERROR);
        }

        $classname = "SyL_DBSchema{$type}";
        include_once dirname(__FILE__) . "/Schema/{$classname}.php";
        $schema =& new $classname($conn);
        return $schema;
    }

    /**
     * 接続しているDBのテーブル一覧を取得する
     *
     * @access public
     * @return array テーブル一覧
     */
    function getTables()
    {
    }

    /**
     * 指定したテーブルの主キーカラムを取得する
     *
     * @access public
     * @param string テーブル名
     * @return array 主キーカラム
     */
    function getPrimary($tablename)
    {
    }

    /**
     * 指定したテーブルの一意キーカラムを取得する
     *
     * @access public
     * @param string テーブル名
     * @return array 一意キーカラム
     */
    function getUniques($tablename)
    {
    }

    /**
     * 指定したテーブルの外部キーカラムを取得する
     *
     * @access public
     * @param string テーブル名
     * @return array 外部キーカラム
     */
    function getForeigns($tablename)
    {
    }

    /**
     * 指定したテーブルのカラム一覧を取得する
     *
     * @access public
     * @param string テーブル名
     * @return array カラム一覧
     */
    function getColumns($tablename)
    {
    }
}
