<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_FileWriter.php,v 1.1 2009/01/11 05:34:31 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ファイル出力クラス
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_FileWriter.php,v 1.1 2009/01/11 05:34:31 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_FileWriter extends SyL_File
{
    /**
     * ファイルオープンモード
     * 
     * @access protected
     * @var string
     */
    var $mode = 'wb';

    /**
     * ファイルを開く
     *
     * @access public
     * @param string オープンモード
     */
    function open()
    {
        parent::open();
        $this->setFileBuffer(0);
    }

    /**
     * ファイルに出力する
     *
     * @access public
     * @param string メッセージ or CSV時 array
     */
    function write($message)
    {
        if ($this->csv) {
            if (!is_array($message)) {
                $message = array($message);
            }
            $message = $this->csv_enclosure . implode($this->csv_enclosure . $this->csv_delimiter . $this->csv_enclosure, $message) . $this->csv_enclosure . $this->eol;
        }

        flock ($this->fp, LOCK_EX);
        fseek($this->fp, 0, SEEK_END);
        fwrite($this->fp, $this->convertEncode($message));
        flock ($this->fp, LOCK_UN);
    }

    /**
     * ファイルに出力する（末尾に改行を付加する）
     *
     * @access public
     * @param string メッセージ or CSV時 array
     */
    function writeln($message)
    {
        if (is_string($message)) {
            $message .= $this->eol;
        }
        $this->write($message);
    }

    /**
     * 出力エンコーディングを変換する
     *
     * @access protected
     * @param string エンコーディング変換前のファイルのデータ
     * @return string エンコーディング変換後のファイルのデータ
     */
    function convertEncode($data)
    {
        if ($this->encode_file) {
            return ($this->encode_script)
                 ? mb_convert_encoding($data, $this->encode_file, $this->encode_script)
                 : mb_convert_encoding($data, $this->encode_file);
        } else {
            return $data;
        }
    }
}
