<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_FormElementCheckbox.php,v 1.1 2009/01/11 05:34:30 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * チェックボックスフォーム要素クラス
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_FormElementCheckbox.php,v 1.1 2009/01/11 05:34:30 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_FormElementCheckbox extends SyL_FormElement
{
    /**
     * ラベル用ID名
     *
     * @access private
     * @var string
     */
    var $label = '_chk';
    /**
     * 要素間の区切り文字
     *
     * @access private
     * @var string
     */
    var $separator = "&nbsp;\r\n";

    /**
     * 要素名（複数）を取得する
     *
     * @access public
     * @return string 要素名
     */
    function getNames()
    {
        return $this->getName() . '[]';
    }

    /**
     * 要素値をセットする
     *
     * @access public
     * @param mixed 要素値
     */
    function setValue($value)
    {
        if (($value === '') || ($value === null)) {
            $this->value = array();
        } else if (!is_array($value)) {
            $this->value = array($value);
        } else {
            $this->value = $value;
        }
    }

    /**
     * 要素間の区切り文字をセット
     *
     * @access public
     * @param string 要素間の区切り文字
     */
    function setSeparator($separetor)
    {
        $this->separator = $separetor;
    }

    /**
     * フォーム要素HTML出力
     *
     * @access public
     * @return string フォーム要素のHTML
     */
    function getHtmlTag()
    {
        $this->setAttribute($this->getNames(), 'name');
        $this->setAttribute($this->type, 'type');

        $i = 0;
        $options = array();
        foreach ($this->options as $key => $value) {
            $id = $this->label . '_' . $this->getName() . '_' . $i;
            $this->setAttribute($id, 'id');
            $this->setAttribute($key, 'value');
            $checked = in_array((string)$key, $this->value, true) ? 'checked' : '';

            $options[] = '<input ' . $this->getAttributes() . ' ' . $checked . ' /><label for="' . $id . '">' . $this->encode($value) . '</label>';
            $i++;
        }

        return implode($this->separator, $options);
    }

    /**
     * フォーム要素HTML出力
     *
     * @access public
     * @return string フォーム要素のHTML
     */
    function getHtmlView()
    {
        $options = array();
        foreach ($this->options as $key => $value) {
            if (in_array((string)$key, $this->value, true)) {
                $options[] = $this->encode($value) . $this->getHtmlHidden($this->getNames(), $key);
            }
        }
  
        return implode($this->separator, $options);
    }

    /**
     * JavaScript入力チェックタグを取得
     *
     * @access public
     * @param string フォーム名
     * @return string JavaScript入力チェックタグ
     */
    function getJs($formname)
    {
        if (is_object($this->validators)) {
            $element = $this->getNames();
            $func    = "check_{$formname}_" . $this->getName() . "(form, errors)";
            $js      = $this->validators->getJs($this->getDisplayName());
            $js = <<< JAVASCRIPT_CODE
function {$func} {
  var validation    = new SyL.Validation.Validation(form);
  var name  = "{$element}";
  var message = '';

{$js}

  if (message) {
    errors.setErrorMessage(name, message);
  }
}

JAVASCRIPT_CODE;
            return array($func, $js);
        } else {
            return array();
        }
    }
}
