<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_FormElementGroup.php,v 1.1 2009/01/11 05:34:30 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * フォーム要素グループクラス
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_FormElementGroup.php,v 1.1 2009/01/11 05:34:30 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_FormElementGroup extends SyL_FormElement
{
    /**
     * フォーム要素配列
     *
     * @access private
     * @var array
     */
    var $elements = array();
    /**
     * 表示フォーマット
     *
     * @access private
     * @var string
     */
    var $format = null;
    /**
     * フォーマット表示配列
     *
     * @access private
     * @var array
     */
    var $format_names = array();

    /**
     * フォームオブジェクトをセットする
     *
     * @access public
     * @param object フォームオブジェクト
     */
    function initGroup(&$form)
    {
    }

    /**
     * フォーム要素オブジェクトを追加する
     *
     * @access public
     * @param object フォーム要素オブジェクト
     */
    function addElement(&$element)
    {
        // 要素オブジェクト格納
        $this->elements[$element->getName()] =& $element;
    }

    /**
     * 表示フォーマットをセットする
     *
     * @access public
     * @param string 表示フォーマット
     */
    function setFormat($format)
    {
        $this->format = $format;
        $this->format_names = array_slice(func_get_args(), 1);
    }

    /**
     * 要素値を取得する
     *
     * @access public
     * @return string 要素名
     */
    function getValue()
    {
        $values = array();
        foreach (array_keys($this->elements) as $name) {
            $values[$name] = $this->elements[$name]->getValue();
        }
        return $values;
    }

    /**
     * 要素値をセットする
     *
     * @access public
     * @param mixed 要素値
     */
    function setValue($value)
    {
        if (is_array($value)) {
            foreach ($value as $name => $value) {
                if (isset($this->elements[$name])) {
                    $this->elements[$name]->setValue($value);
                }
            }
        }
    }

    /**
     * フォーム要素表示判定フラグをセット
     *
     * @access public
     * @param bool フォーム要素表示判定フラグ
     */
    function setReadOnly($read_only)
    {
        foreach (array_keys($this->elements) as $name) {
            $values[$name] = $this->elements[$name]->setReadOnly($read_only);
        }
        parent::setReadOnly($read_only);
    }

    /**
     * 必須チェック存在判定
     * ※検証グループオブジェクトをセットしてから実行する
     *
     * @access public
     * @return bool true: 必須チェックあり、false: 必須チェック無し
     */
    function isRequire()
    {
        $is = false;
        foreach (array_keys($this->elements) as $name) {
            if ($this->elements[$name]->isRequire()) {
                $is = true;
                break;
            }
        }
        return $is;
    }

    /**
     * フォーム要素HTML出力（入力項目）
     *
     * @access public
     * @return string フォーム要素のHTML
     */
    function getHtmlTag()
    {
        $htmls = array();
        if ($this->format) {
            $htmls[] = $this->format;
            foreach ($this->format_names as $name) {
                $htmls[] = $this->elements[$name]->getHtmlTag();
            }
            return call_user_func_array('sprintf', $htmls);
        } else {
            foreach ($this->elements as $element) {
                $htmls[] = $element->getHtmlTag();
            }
            return implode('', $htmls);
        }
    }

    /**
     * フォーム要素HTML出力（表示）
     *
     * @access public
     * @return string フォーム要素のHTML
     */
    function getHtmlView()
    {
        $htmls = array();
        if ($this->format) {
            $htmls[] = $this->format;
            foreach ($this->format_names as $name) {
                $htmls[] = $this->elements[$name]->getHtmlView();
            }
            return call_user_func_array('sprintf', $htmls);
        } else {
            foreach ($this->elements as $element) {
                $htmls[] = $element->getHtmlView();
            }
            return implode('', $htmls);
        }
    }

    /**
     * 検証グループオブジェクトをセット
     *
     * @access public
     * @param object 検証グループオブジェクト
     */
    function setValidators(&$validators)
    {
        foreach (array_keys($this->elements) as $name) {
            $this->elements[$name]->setValidators($validators);
        }
    }

    /**
     * 検証を実行する
     * 検証グループオブジェクトがない場合は、常にtrue
     *
     * @access public
     * @return bool true: エラー無し、false: エラーあり
     */
    function validate()
    {
        foreach (array_keys($this->elements) as $name) {
            if (!$this->elements[$name]->validate()) {
                $this->error_message = $this->elements[$name]->getErrorMessage();
                return false;
            }
        }
        return true;
    }

    /**
     * JavaScript入力チェックタグを取得
     *
     * @access public
     * @return string JavaScript入力チェックタグ
     */
    function getJs($formname)
    {
        $js     = '';
        $error_confirm = array();
        foreach (array_keys($this->elements) as $name) {
            $tmp     = $this->elements[$name]->getJs($formname);
            $element = $this->elements[$name]->getNames();
            if (count($tmp) == 2) {
                if (count($error_confirm) > 0) {
                    $js .= 'if (' . implode(' && ', $error_confirm) . ') {' . "\n";
                    $js .= $tmp[1] . "\n";
                    $js .= $tmp[0] . ';' . "\n";
                    $js .= '}' . "\n";
                } else {
                    $js .= $tmp[1] . "\n";
                    $js .= $tmp[0] . ';' . "\n";
                }
            }
            $error_confirm[] = "!errors.isError('{$element}')";
        }

        if ($js) {
            $element = $this->getName();
            $func    = "check_{$formname}_{$element}(form, errors)";
            $js   = <<< JAVASCRIPT_CODE
function {$func}
{
  var validation    = new SyL.Validation.Validation(form);
  var name  = "{$element}";
  var message = "";

{$js}

  if (message) {
    errors.setErrorMessage(name, message);
  }
}

JAVASCRIPT_CODE;
            return array($func, $js);
        } else {
            return array();
        }
    }
}
