<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_FormElementHidden.php,v 1.1 2009/01/11 05:34:30 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * 隠しフォーム要素クラス
 *
 * 名前 : 要素部品名 : 要素名(name) : 値(value)
 *   1  :      -     :    1         :   1
 *
 * ○インスタンス作成方法
 * // 基底クラスからスタティックメソッドで取得
 * $SyL_FormElementHidden = SyL_FormElement::createElement( 'hidden', 'name', '名前' );
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_FormElementHidden.php,v 1.1 2009/01/11 05:34:30 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_FormElementHidden extends SyL_FormElement
{
    /**
     * フォーム要素HTML出力（入力項目）
     *
     * @access public
     * @return string フォーム要素のHTML
     */
    function getHtmlTag()
    {
        return $this->getHtmlHidden();
    }

    /**
     * フォーム要素HTML出力（表示）
     *
     * @access public
     * @return string フォーム要素のHTML
     */
    function getHtmlView()
    {
        return $this->getHtmlHidden();
    }
}
