<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebService.php,v 1.1 2009/01/11 05:34:29 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBサービスリクエストクラス
 */
require_once dirname(__FILE__) . '/WebService/SyL_WebServiceRequest.php';
/**
 * WEBサービスレスポンスクラス
 */
require_once dirname(__FILE__) . '/WebService/SyL_WebServiceResponse.php';
/**
 * HTTPクライアントクラス
 */
require_once dirname(__FILE__) . '/Http/SyL_HttpClient.php';

/**
 * WEBサービスクラス
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebService.php,v 1.1 2009/01/11 05:34:29 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_WebService
{
    /**
     * クライアントエンコード
     *
     * @access protected
     * @var string
     */
    var $client_encode = '';
    /**
     * サーバーエンコード
     *
     * @access protected
     * @var string
     */
    var $server_encode = 'UTF-8';
    /**
     * キャッシュオブジェクト
     *
     * @access protected
     * @var object
     */
    var $cache = null;

    /**
     * コンストラクタ
     * 
     * @access public
     */
    function SyL_WebService()
    {
        $this->client_encode = mb_internal_encoding();
    }

    /**
     * WEBサービス実行クラスのインスタンス取得
     *
     * @static
     * @access public
     * @param string WEBサービスタイプ
     * @return object WEBサービス実行クラス
     */
    function &factory($type)
    {
        $class_name = 'SyL_WebService' . str_replace('.', '_', ucfirst($type));
        include_once dirname(__FILE__) . '/WebService/' . $class_name . '.php';
        $service =& new $class_name();
        return $service;
    }

    /**
     * クライアントエンコードをセットする
     *
     * @access public
     * @param string クライアントエンコード
     */
    function setClientEncode($client_encode)
    {
        $this->client_encode = $client_encode;
    }

    /**
     * サーバーエンコードをセットする
     *
     * @access public
     * @param string サーバーエンコード
     */
    function setServerEncode($server_encode)
    {
        $this->server_encode = $server_encode;
    }

    /**
     * パラメータをエンコードする
     *
     * @access public
     * @param string エンコード前パラメータ
     * @return string エンコード後パラメータ
     */
    function convertEncoding($value)
    {
        if ($this->client_encode && $this->server_encode) {
            $value = mb_convert_encoding($value, $this->server_encode, $this->client_encode);
        } else if ($this->server_encode) {
            $value = mb_convert_encoding($value, $this->server_encode);
        }
        return $value;
    }

    /**
     * キャッシュオブジェクトをセットする
     *
     * @access public
     * @param object キャッシュオブジェクト
     */
    function setCache(&$cache)
    {
        $this->cache =& $cache;
    }

    /**
     * リクエストを送信する
     * 
     * @access public
     * @return object メールメッセージオブジェクト
     */
    function &sendRequest(&$request)
    {
        $type = $request->getRequestType();
        $ssl  = $request->isSsl();
        $host = $request->getRequestHost();
        $port = $request->getRequestPort();
        $path = $request->getRequestPath();
        $parameters = $request->gets();

        $response = null;
        $cache    = null;
        if ($this->cache !== null) {
            // 参照解除
            if (version_compare(PHP_VERSION, '5.0.0', '>=')) {
                $cache = unserialize(serialize($this->cache));
            } else {
                $cache = $this->cache;
            }

            if ($cache->getKey(false) === '') {
                $key = (string)$ssl.$host.$port.$path.print_r($parameters, true);
                $cache->setKey($key);
            }
            $response = $cache->read();
            if ($response) {
                // キャッシュOK
                $cache = null;
                return $response;
            }
        }

        switch ($type) {
        case 'rest':
            $client =& new SyL_HttpClient($host, $port, $ssl);
            $http_request =& $client->createRequest($path, 'GET');
            foreach ($parameters as $name => $value) {
                $http_request->set($this->convertEncoding($name), $this->convertEncoding($value));
            }
            $http_response =& $client->sendRequest($http_request, $this->client_encode);
            $response = $this->createResponse($http_response->getResponseStatus(), $http_response->getResult(), $request->getResponseClass());
            break;
//        case 'xmlrpc':
//            break;
        default:
            trigger_error("[SyL error] Invalid request type ({$type})", E_USER_ERROR);
        }

        if ($cache !== null) {
            // キャッシュ書き込み
            $cache->write($response);
        }

        return $response;
    }

    /**
     * WEBサービスレスポンスオブジェクトを取得する
     * 
     * @access protected
     * @param string レスポンスステータス
     * @param string レスポンスデータ
     * @param string レスポンスクラス名
     * @return object WEBサービスレスポンスオブジェクト
     */
    function &createResponse($response_status, $result, $classname)
    {
        $response =& new $classname($response_status, $result, $this->server_encode, $this->client_encode);
        return $response;
    }
}
