<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_UtilCompositeComposite.php,v 1.1 2009/01/11 05:34:31 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * コンポジットパターンに基づく基底クラス
 */
require_once 'SyL_UtilCompositeComponent.php';

/**
 * コンポジットパターンに基づく要素グループクラス
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_UtilCompositeComposite.php,v 1.1 2009/01/11 05:34:31 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_UtilCompositeComposite extends SyL_CompositeComponent
{
    /**
     * 子要素格納配列
     * 
     * @access private
     * @var array
     */
    var $entry = array();

    /**
     * コンストラクタ
     *
     * @access public
     * @param object 子要素
     */
    function SyL_CompositeComposite($name=null)
    {
        parent::SyL_CompositeComponent($name);
    }

    /**
     * 子要素を追加する
     *
     * @access public
     * @param object 子要素
     */
    function add($entry)
    {
        $this->entry[] = $entry;
    }

    /**
     * ツリーを表示する
     *
     * @access public
     * @param int 深さ
     */
    function printTree($depth=0)
    {
        echo str_repeat('    ', $depth);
        echo "+ {$this->name}\n";
        $depth++;
        foreach ($this->entry as $node) {
            $node->printTree($depth);
        }
    }

    /**
     * ツリーを取得する
     *
     * @access public
     * @param array ツリーデータ
     */
    function getTree($tree=array())
    {
        $tree['name']       = $this->name;
        $tree['attributes'] = $this->getAttributes();
        $tree['nodes']      = array();
        foreach ($this->entry as $node) {
            $tree['nodes'][] = $node->getTree(array());
        }
        return $tree;
    }
}
