<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_UtilRemoteHostMesh_ad_jp.php,v 1.1 2009/01/11 05:34:31 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * リモートホスト判定クラス (mesh.ad.jp)
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_UtilRemoteHostMesh_ad_jp.php,v 1.1 2009/01/11 05:34:31 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_UtilRemoteHostMesh_ad_jp extends SyL_UtilRemoteHost
{
    /**
     * ドメイン
     *
     * @access protected
     * @var string
     */
    var $domain = 'mesh.ad.jp';
    /**
     * プロバイダ名
     *
     * @access protected
     * @var string
     */
    var $provider = 'BIGLOBE';
    /**
     * プロバイダURL
     *
     * @access protected
     * @var string
     */
    var $url = 'http://www.biglobe.ne.jp/';
    /**
     * 運営会社名
     *
     * @access protected
     * @var string
     */
    var $company = 'NECビッグローブ株式会社';

    /**
     * 都道府県判定用配列
     *
     * @access protected
     * @var array
     */
    var $prefectures = array(
      '.hkd.' => '01',
      '.aom.' => '02',
      '.iwa.' => '03',
      '.myg.' => '04',
      '.aki.' => '05',
      '.ygt.' => '06',
      '.fks.' => '07',
      '.iba.' => '08',
      '.tcg.' => '09',
      '.gnm.' => '10',
      '.stm.' => '11',
      '.chb.' => '12',
      '.tky.' => '13',
      '.kng.' => '14',
      '.nig.' => '15',
      '.tym.' => '16',
      '.isk.' => '17',
      '.fki.' => '18',
      '.ymn.' => '19',
      '.ngn.' => '20',
      '.gif.' => '21',
      '.szo.' => '22',
      '.aic.' => '23',
      '.mie.' => '24',
      '.sig.' => '25',
      '.kyt.' => '26',
      '.osk.' => '27',
      '.hyg.' => '28',
      '.nra.' => '29',
      '.wky.' => '30',
      '.ttr.' => '31',
      '.smn.' => '32',
      '.oky.' => '33',
      '.hrs.' => '34',
      '.ygc.' => '35',
      '.tks.' => '36',
      '.kgw.' => '37',
      '.ehm.' => '38',
      '.koc.' => '39',
      '.fko.' => '40',
      '.sag.' => '41',
      '.ngs.' => '42',
      '.kmm.' => '43',
      '.oit.' => '44',
      '.myz.' => '45',
      '.kgs.' => '46',
      '.okn.' => '47'
    );

    /**
     * 回線種別判定用配列
     *
     * @access protected
     * @var array
     */
    var $connection_type = array(
      'FLA'   => 'adsl-ntt',
      'TOKa'  => 'adsl-tokai',
      'ACCA'  => 'adsl-acca',
      'eAc'   => 'adsl-eaccess',
      'FLH'   => 'opt-ntt',
      'TPH'   => 'opt-tepco',
      'freeD' => 'freed',
      'Air'   => 'airedge',
      'IP'    => 'isdn-ntt'
    );
}
