<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_UtilJson.php,v 1.1 2009/01/11 05:34:29 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

if (!function_exists('json_encode')) {
function json_encode($value)
{
    return preg_replace('/(\r\n|\r|\n)/', '\\\n', SyL_UtilJson::encode($value));
}
}

/**
 * Jsonクラス
 *
 * ※エンコードのみ。5.2以上では使用しない（標準実装されるので）
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_UtilJson.php,v 1.1 2009/01/11 05:34:29 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_UtilJson
{
    /**
     * PHP変数をJSON形式にエンコードする
     *
     * @static
     * @access public
     * @param mixed 変換対象値
     * @return string 変換後値
     */
    function encode($value)
    {
        $class_name = __CLASS__;
        if (is_string($value)) {
            return call_user_func(array($class_name, 'encodeString'), $value);
        } else if (is_int($value) || is_float($value)) {
            return call_user_func(array($class_name, 'encodeNumber'), $value);
        } else if (is_bool($value)) {
            return call_user_func(array($class_name, 'encodeBoolean'), $value);
        } else if (is_null($value)) {
            return call_user_func(array($class_name, 'encodeNull'), $value);
        } else if (is_array($value)) {
            return call_user_func(array($class_name, 'encodeArray'), $value);
        } else if (is_object($value)) {
            return call_user_func(array($class_name, 'encodeObject'), $value);
        } else {
            trigger_error("[SyL error] invalid format (" . gettype($value) . ")", E_USER_ERROR);
        }
    }

    /**
     * 文字列をJSON形式文字列に変換する
     *
     * @access public
     * @static
     * @param string 変換前値
     * @return string 変換後値
     */
    function encodeString($value)
    {
        return "\"" . preg_replace('/(\"|\\\\)/', '\\\\$1', $value) . "\"";
    }

    /**
     * 数値をJSON形式文字列に変換する
     *
     * @access public
     * @static
     * @param int 変換前値
     * @return string 変換後値
     */
    function encodeNumber($value)
    {
        return (string)$value;
    }

    /**
     * 論理型をJSON形式文字列に変換する
     *
     * @access public
     * @static
     * @param bool 変換前値
     * @return string 変換後値
     */
    function encodeBoolean($value)
    {
        return ($value) ? "true" : "false";
    }

    /**
     * NULLをJSON形式文字列に変換する
     *
     * @access public
     * @static
     * @param null 変換前値
     * @return string 変換後値
     */
    function encodeNull($value)
    {
        return "null";
    }

    /**
     * 配列をJSON形式文字列に変換する
     *
     * @access public
     * @static
     * @param array 変換前値
     * @return string 変換後値
     */
    function encodeArray($value)
    {
        $class_name = __CLASS__;
        $len = count($value);
        if ($len > 0) {
            if (array_keys($value) === range(0, $len-1)) {
                return '[' . join(',', array_map(array($class_name, 'encode'), $value)) . ']';
            } else {
                return call_user_func(array($class_name, 'encodeObject'), $value);
            }
        } else {
            return "[]";
        }
    }

    /**
     * オブジェクトをJSON形式文字列に変換する
     *
     * @access public
     * @static
     * @param object 変換前値
     * @return string 変換後値
     */
    function encodeObject($value)
    {
        $class_name = __CLASS__;
        $result = array();
        foreach ($value as $key => $variant) {
            $result[] = call_user_func(array($class_name, 'encode'), (string)$key) . ':'
                      . call_user_func(array($class_name, 'encode'), $variant);
        }
        return '{' . join(',', $result) . '}';
    }
}
