<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ValidationConfigXml.php,v 1.1 2009/01/11 05:34:34 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * XMLリーダクラス
 */
require_once dirname(__FILE__) . '/../../Xml/SyL_XmlReader.php';

/**
 * 検証XML設定クラス
 * 
 * ファイル例）
 *
 * ...
 * <validations>
 *   <validation name="def1" displayName="名前">
 *     <validator name="require" errorMessage="{name}は必須です">
 *       <option name="max" value="19" />
 *       <option name="min" value="1" />
 *     </validator>
 *     <validator name="require" errorMessage="{name}は必須です">
 *       <option name="max" value="19" />
 *       <option name="min" value="1" />
 *     </validator>
 *   </validation>
 *   ...
 * </validations>
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ValidationConfigXml.php,v 1.1 2009/01/11 05:34:34 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_ValidationConfigXml extends SyL_ValidationConfig
{
    /**
     * 検証設定パース
     *
     * @access protected
     */
    function parse()
    {
        $reader =& new SyL_ValidationConfigXmlReader();
        $reader->setFile($this->filename);
        $reader->parseXml();
        $this->config = $reader->getConfig();
        $this->config_name = $reader->getConfigName();
    }
}


/**
 * 検証XML設定読み込みクラス
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ValidationConfigXml.php,v 1.1 2009/01/11 05:34:34 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_ValidationConfigXmlReader extends SyL_XmlReader
{
    /**
     * 検証設定配列
     *
     * @access protected
     * @var array
     */
    var $config = array();
    /**
     * 検証設定配列（名前）
     *
     * @access protected
     * @var array
     */
    var $config_name = array();

    /**
     * XMLデータ内容取得ハンドラメソッド
     * ※オーバーライド
     *
     * @access protected
     * @param string 現在XML解析中のパス
     * @param string XMLのタグの属性値
     * @param string XMLのタグの値
     */
    function getElement($current_path, $attribute, $text)
    {
        static $i = -1;
        static $validation = '';

        // XML解析結果を取得
        switch ($current_path) {
        case '/validations/validation':
            $validation = $attribute['name'];
            $this->config[$validation]      = array();
            $this->config_name[$validation] = isset($attribute['displayName']) ? $attribute['displayName'] : $validation;
            $i = -1;
            break;
        case '/validations/validation/validator':
            $i++;
            $this->config[$validation][$i]['validator']    = $attribute['name'];
            $this->config[$validation][$i]['errorMessage'] = $attribute['errorMessage'];
            break;
        case '/validations/validation/validator/option':
            $this->config[$validation][$i]['options'][$attribute['name']] = $attribute['value'];
            break;
        }
    }

    /**
     * XML設定値を取得
     * 
     * @return array 設定値配列
     */
    function getConfig()
    {
        return $this->config;
    }

    /**
     * XML設定値を取得（名前）
     * 
     * @return array 設定値配列（名前）
     */
    function getConfigName()
    {
        return $this->config_name;
    }
}
