<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ValidationValidators.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * 検証個別グループクラス
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ValidationValidators.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_ValidationValidators extends SyL_Validation
{
    /**
     * 個別検証クラスをまとめた配列
     *
     * @access private
     * @var array
     */
    var $validators = array();

    /**
     * グループ検証オブジェクトの取得
     *
     * @static
     * @access public
     * @return object グループ検証オブジェクト
     */
    function &create()
    {
        $classname = __CLASS__;
        $validators =& new $classname();
        return $validators;
    }

    /**
     * 個別検証オブジェクトを追加する
     *
     * @access public
     * @param object 個別検証オブジェクト
     */
    function add(&$validator)
    {
        if (version_compare(PHP_VERSION, '5.0.0', '>=')) {
            $this->validators[] = unserialize(serialize($validator));
        } else {
            $this->validators[] = $validator;
        }
    }

    /**
     * 必須チェック存在判定
     *
     * @access public
     * @return bool true: 必須チェックあり、false: 必須チェック無し
     */
    function isRequire()
    {
        foreach (array_keys($this->validators) as $key) {
            if ($this->validators[$key]->isRequire()) {
                return true;
            }
        }
        return false;
    }

    /**
     * 検証処理を実行する
     *
     * @access public
     * @param string 検証対象値
     * @param string 検証対象名
     * @return bool true: エラー無し, false: エラーあり
     */
    function execute($value, $name='')
    {
        foreach (array_keys($this->validators) as $key) {
            if (!$this->validators[$key]->execute($value, $name)) {
                $this->error_message = $this->validators[$key]->getErrorMessage();
                return false;
            }
        }
        return true;
    }

    /**
     * JavaScript処理ロジックを取得する
     *
     * @access public
     * @param string フォーム要素表示名
     * @param array フォーム要素の部品配列（radio, select, checkboxの場合のみ）
     * @return string JavaScript処理ロジック
     */
    function getJs($display_name)
    {
        $js = '';
        foreach (array_keys($this->validators) as $key) {
            $tmp = $this->validators[$key]->getJs($display_name);
            if ($tmp) {
                if ($this->validators[$key]->isRequire()) {
                    $js .= 'if (!message) {' . "\n";
                } else {
                    $js .= 'if (!message && !validation.isRequire(name, "require!")) {' . "\n";
                }
                $js .= $tmp . "\n";
                $js .= '}' . "\n";
            }
        }
        return $js;
    }
}

/**
 * エイリアス
 */
class SyL_Validators extends SyL_ValidationValidators{}
