<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceWeatherRequest.php,v 1.1 2009/01/11 05:34:32 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBサービスレスポンスクラス（お天気Webサービス用）
 */
require_once 'SyL_WebServiceWeatherResponse.php';

/**
 * WEBサービスリクエストクラス（お天気Webサービス用）
 *
 * 詳細は、Weather Hacks（気象データ配信サービス）参照
 *   http://weather.livedoor.com/weather_hacks/
 * お天気Webサービス
 *   http://weather.livedoor.com/weather_hacks/webservice.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceWeatherRequest.php,v 1.1 2009/01/11 05:34:32 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_WebServiceWeatherRequest extends SyL_WebServiceLivedoor_comRequest
{
    /**
     * WEBサービスサーバーのホスト名
     *
     * @access protected
     * @var string
     */
    var $host = 'weather.livedoor.com';
    /**
     * 実行URLパス
     *
     * @access protected
     * @var string
     */
    var $path = '/forecast/webservice/rest/v1';
    /**
     * レスポンスクラス名
     *
     * @access protected
     * @var string
     */
    var $response_class = 'SyL_WebServiceWeatherResponse';

    /**
     * 地域別に定義されたID番号をセットする
     *
     * @access public
     * @param string 地域別に定義されたID番号
     */
    function setCity($city)
    {
        if (preg_match('/^\d+$/', $city)) {
            parent::set('city', $city);
        } else {
            trigger_error("[SyL error] Invalid `city' property ({$city}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * リクエストする予報日をセットする
     *
     * @access public
     * @param string リクエストする予報日
     */
    function setDay($day)
    {
        switch ($day) {
        case 'today':
        case 'tomorrow':
        case 'dayaftertomorrow':
            parent::set('day', $day);
            break;
        default:
            trigger_error("[SyL error] Invalid `day' property ({$day}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }
}
