<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceAuctionAuctionItemCodeSearchResponse.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBサービスレスポンスクラス（楽天 - 楽天オークション商品コード検索API用）
 *
 * 詳細は、楽天ウェブサービスセンター参照
 *   http://webservice.rakuten.co.jp/
 * 楽天オークション商品コード検索API
 *   http://webservice.rakuten.co.jp/api/auctionitemcodesearch/
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceAuctionAuctionItemCodeSearchResponse.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_WebServiceAuctionAuctionItemCodeSearchResponse extends SyL_WebServiceRakuten_co_jpResponse
{
    /**
     * 商品情報
     *
     * @access private
     * @var array
     */
    var $item = array();

    /**
     * XMLデータ内容取得ハンドラメソッド
     *
     * @access protected
     * @param string 現在XML解析中のパス
     * @param string XMLのタグの属性値
     * @param string XMLのタグの値
     */
    function getElement($current_path, $attribute, $text)
    {
        switch ($current_path) {
        // =============================
        // 正常系
        // =============================
        // 商品名
        case '/Response/Body/auctionItemCodeSearch:AuctionItemCodeSearch/Item/itemName': $this->item['itemName'] = $text; break;
        // オークション商品コード
        case '/Response/Body/auctionItemCodeSearch:AuctionItemCodeSearch/Item/itemCode': $this->item['itemCode'] = $text; break;
        // 出品商品現在価格
        case '/Response/Body/auctionItemCodeSearch:AuctionItemCodeSearch/Item/itemPrice': $this->item['itemPrice'] = $text; break;
        // 最低入札価格
        case '/Response/Body/auctionItemCodeSearch:AuctionItemCodeSearch/Item/minPrice': $this->item['minPrice'] = $text; break;
        // 商品説明分
        case '/Response/Body/auctionItemCodeSearch:AuctionItemCodeSearch/Item/itemCaption': $this->item['itemCaption'] = $text; break;
        // 商品URL
        case '/Response/Body/auctionItemCodeSearch:AuctionItemCodeSearch/Item/itemUrl': $this->item['itemUrl'] = $text; break;
        // アフィリエイトURL
        case '/Response/Body/auctionItemCodeSearch:AuctionItemCodeSearch/Item/affiliateUrl': $this->item['affiliateUrl'] = $text; break;
        // 商品画像有無フラグ
        case '/Response/Body/auctionItemCodeSearch:AuctionItemCodeSearch/Item/imageFlag': $this->item['imageFlag'] = $text; break;
        // 商品画像64x64URL
        case '/Response/Body/auctionItemCodeSearch:AuctionItemCodeSearch/Item/smallImageUrl': $this->item['smallImageUrl'] = $text; break;
        // 商品画像128x128URL
        case '/Response/Body/auctionItemCodeSearch:AuctionItemCodeSearch/Item/mediumImageUrl': $this->item['mediumImageUrl'] = $text; break;
        // 即落フラグ
        case '/Response/Body/auctionItemCodeSearch:AuctionItemCodeSearch/Item/blowFlag': $this->item['blowFlag'] = $text; break;
        // 結果フラグ
        case '/Response/Body/auctionItemCodeSearch:AuctionItemCodeSearch/Item/resultFlag': $this->item['resultFlag'] = $text; break;
        // 入札件数
        case '/Response/Body/auctionItemCodeSearch:AuctionItemCodeSearch/Item/bidCount': $this->item['bidCount'] = $text; break;
        // 消費税フラグ
        case '/Response/Body/auctionItemCodeSearch:AuctionItemCodeSearch/Item/taxFlag': $this->item['taxFlag'] = $text; break;
        // 送料フラグ
        case '/Response/Body/auctionItemCodeSearch:AuctionItemCodeSearch/Item/postageFlag': $this->item['postageFlag'] = $text; break;
        // クレジットカード利用可能フラグ
        case '/Response/Body/auctionItemCodeSearch:AuctionItemCodeSearch/Item/creditCardFlag': $this->item['creditCardFlag'] = $text; break;
        // アフィリエイト利用利率
        case '/Response/Body/auctionItemCodeSearch:AuctionItemCodeSearch/Item/affiliateRate': $this->item['affiliateRate'] = $text; break;
        // 販売開始時刻
        case '/Response/Body/auctionItemCodeSearch:AuctionItemCodeSearch/Item/startTime': $this->item['startTime'] = $text; break;
        // 販売終了時刻
        case '/Response/Body/auctionItemCodeSearch:AuctionItemCodeSearch/Item/endTime': $this->item['endTime'] = $text; break;
        // 出品者名
        case '/Response/Body/auctionItemCodeSearch:AuctionItemCodeSearch/Item/shopName': $this->item['shopName'] = $text; break;
        // 出品者種別フラグ
        case '/Response/Body/auctionItemCodeSearch:AuctionItemCodeSearch/Item/shopStatusFlag': $this->item['shopStatusFlag'] = $text; break;
        // ジャンルID
        case '/Response/Body/auctionItemCodeSearch:AuctionItemCodeSearch/Item/genreId': $this->item['genreId'] = $text; break;

        // 上記以外
        default: parent::getElement($current_path, $attribute, $text);
        }
    }

    /**
     * オークション商品情報を取得する
     *
     * @access public
     * @param string キー名
     * @return mixed オークション商品情報
     */
    function getItem($name=null)
    {
        if ($name !== null) {
            return isset($this->item[$name]) ? $this->item[$name] : null;
        } else {
            return $this->item;
        }
    }

}
