<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceBooksBookSearchRequest.php,v 1.1 2009/01/11 05:34:34 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBサービスレスポンスクラス（楽天 - 楽天書籍検索API用）
 */
require_once 'SyL_WebServiceBooksBookSearchResponse.php';

/**
 * WEBサービスクラス（楽天 - 楽天書籍検索API用）
 *
 * 詳細は、楽天ウェブサービスセンター参照
 *   http://webservice.rakuten.co.jp/
 * 楽天書籍検索API
 *   http://webservice.rakuten.co.jp/api/booksearch/
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceBooksBookSearchRequest.php,v 1.1 2009/01/11 05:34:34 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_WebServiceBooksBookSearchRequest extends SyL_WebServiceRakuten_co_jpRequest
{
    /**
     * 実行URLパス
     *
     * @access protected
     * @var string
     */
    var $path = '/rws/1.11/rest';
    /**
     * レスポンスクラス名
     *
     * @access protected
     * @var string
     */
    var $response_class = 'SyL_WebServiceBooksBookSearchResponse';

    /**
     * 検索キーワードをセットする
     *
     * @access public
     * @param string 検索キーワード
     */
    function setKeyword($keyword)
    {
        parent::set('keyword', $keyword);
    }

    /**
     * バージョンをセットする
     *
     * @access public
     * @param string バージョン
     */
    function setVersion($version)
    {
        parent::set('version', $version);
    }

    /**
     * ジャンルIDをセットする
     *
     * @access public
     * @param int ジャンルID
     */
    function setGenreId($genreId)
    {
        if (preg_match('/^\d+$/', $genreId)) {
            parent::set('genreId', $genreId);
        } else {
            trigger_error("[SyL error] Invalid `genreId' property ({$genreId}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 1ページあたりの取得件数をセットする
     *
     * @access public
     * @param int 1ページあたりの取得件数
     */
    function setHits($hits)
    {
        if (preg_match('/^\d+$/', $hits) && (($hits >= 1) && ($hits <= 30))) {
            parent::set('hits', $hits);
        } else {
            trigger_error("[SyL error] Invalid `hits' property ({$hits}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 取得ページをセットする
     *
     * @access public
     * @param int 取得ページ
     */
    function setPage($page)
    {
        if (preg_match('/^\d+$/', $page) && (($page >= 1) && ($page <= 100))) {
            parent::set('page', $page);
        } else {
            trigger_error("[SyL error] Invalid `page' property ({$page}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ソートをセットする
     *
     * @access public
     * @param string ソート
     */
    function setSort($sort)
    {
        switch ($sort) {
        case '+affiliateRate':
        case '-affiliateRate':
        case '+reviewCount':
        case '-reviewCount':
        case '+itemPrice':
        case '-itemPrice':
        case '+updateTimestamp':
        case '-updateTimestamp':
        case 'random':
            parent::set('sort', $sort);
            break;
        default:
            trigger_error("[SyL error] Invalid `sort' property ({$sort}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 最小価格をセットする
     *
     * @access public
     * @param int 最小価格
     */
    function setMinPrice($minPrice)
    {
        if (preg_match('/^\d+$/', $minPrice)) {
            parent::set('minPrice', $minPrice);
        } else {
            trigger_error("[SyL error] Invalid `minPrice' property ({$minPrice}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 最大価格をセットする
     *
     * @access public
     * @param int 最大価格
     */
    function setMaxPrice($maxPrice)
    {
        if (preg_match('/^\d+$/', $maxPrice)) {
            parent::set('maxPrice', $maxPrice);
        } else {
            trigger_error("[SyL error] Invalid `maxPrice' property ({$maxPrice}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 販売可能をセットする
     *
     * @access public
     * @param int 販売可能
     */
    function setAvailability($availability)
    {
        switch ((string)$availability) {
        case '0':
        case '1':
            parent::set('availability', $availability);
            break;
        default:
            trigger_error("[SyL error] Invalid `availability' property ({$availability}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 検索フィールドをセットする
     *
     * @access public
     * @param int 検索フィールド
     */
    function setField($field)
    {
        switch ((string)$field) {
        case '0':
        case '1':
            parent::set('field', $field);
            break;
        default:
            trigger_error("[SyL error] Invalid `field' property ({$field}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * キャリアをセットする
     *
     * @access public
     * @param int キャリア
     */
    function setCarrier($carrier)
    {
        switch ((string)$carrier) {
        case '0':
        case '1':
            parent::set('carrier', $carrier);
            break;
        default:
            trigger_error("[SyL error] Invalid `carrier' property ({$carrier}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 商品画像有無フラグをセットする
     *
     * @access public
     * @param int 商品画像有無フラグ
     */
    function setImageFlag($imageFlag)
    {
        switch ((string)$imageFlag) {
        case '0':
        case '1':
            parent::set('imageFlag', $imageFlag);
            break;
        default:
            trigger_error("[SyL error] Invalid `imageFlag' property ({$imageFlag}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * OR検索フラグをセットする
     *
     * @access public
     * @param int OR検索フラグ
     */
    function setOrFlag($orFlag)
    {
        switch ((string)$orFlag) {
        case '0':
        case '1':
            parent::set('orFlag', $orFlag);
            break;
        default:
            trigger_error("[SyL error] Invalid `orFlag' property ({$orFlag}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 除外キーワードをセットする
     *
     * @access public
     * @param string 除外キーワード
     */
    function setNGKeyword($NGKeyword)
    {
        parent::set('NGKeyword', $NGKeyword);
    }

    /**
     * ジャンルごとの商品数取得フラグをセットする
     *
     * @access public
     * @param int ジャンルごとの商品数取得フラグ
     */
    function setGenreInformationFlag($genreInformationFlag)
    {
        switch ((string)$genreInformationFlag) {
        case '0':
        case '1':
            parent::set('genreInformationFlag', $genreInformationFlag);
            break;
        default:
            trigger_error("[SyL error] Invalid `genreInformationFlag' property ({$genreInformationFlag}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }
}
