<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceMarketGenreSearchRequest.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBサービスレスポンスクラス（楽天 - 楽天ジャンル検索API用）
 */
require_once 'SyL_WebServiceMarketGenreSearchResponse.php';

/**
 * WEBサービスクラス（楽天 - 楽天ジャンル検索API用）
 *
 * 詳細は、楽天ウェブサービスセンター参照
 *   http://webservice.rakuten.co.jp/
 * 楽天ジャンル検索API 
 *   http://webservice.rakuten.co.jp/api/genresearch/
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceMarketGenreSearchRequest.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_WebServiceMarketGenreSearchRequest extends SyL_WebServiceRakuten_co_jpRequest
{
    /**
     * 実行URLパス
     *
     * @access protected
     * @var string
     */
    var $path = '/rws/1.11/rest';
    /**
     * レスポンスクラス名
     *
     * @access protected
     * @var string
     */
    var $response_class = 'SyL_WebServiceMarketGenreSearchResponse';

    /**
     * ジャンルIDをセットする
     *
     * @access public
     * @param int ジャンルID
     */
    function setGenreId($genreId)
    {
        if (preg_match('/^\d+$/', $genreId)) {
            parent::set('genreId', $genreId);
        } else {
            trigger_error("[SyL error] Invalid `genreId' property ({$genreId}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * バージョンをセットする
     *
     * @access public
     * @param string バージョン
     */
    function setVersion($version)
    {
        parent::set('version', $version);
    }

    /**
     * ジャンルパスをセットする
     *
     * @access public
     * @param int ジャンルパス
     */
    function setGenrePath($genrePath)
    {
        switch ((string)$genrePath) {
        case '0':
        case '1':
            parent::set('genrePath', $genrePath);
            break;
        default:
            trigger_error("[SyL error] Invalid `genrePath' property ({$genrePath}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }
}
