<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceMarketItemCodeSearchResponse.php,v 1.1 2009/01/11 05:34:32 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBサービスレスポンスクラス（楽天 - 楽天商品コード検索API用）
 *
 * 詳細は、楽天ウェブサービスセンター参照
 *   http://webservice.rakuten.co.jp/
 * 楽天商品コード検索API 
 *   http://webservice.rakuten.co.jp/api/genresearch/
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceMarketItemCodeSearchResponse.php,v 1.1 2009/01/11 05:34:32 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_WebServiceMarketItemCodeSearchResponse extends SyL_WebServiceRakuten_co_jpResponse
{
    /**
     * 商品情報
     *
     * @access private
     * @var array
     */
    var $genreId = array();

    /**
     * XMLデータ内容取得ハンドラメソッド
     *
     * @access protected
     * @param string 現在XML解析中のパス
     * @param string XMLのタグの属性値
     * @param string XMLのタグの値
     */
    function getElement($current_path, $attribute, $text)
    {
        switch ($current_path) {
        // =============================
        // 正常系
        // =============================
        // キャリア情報
        case '/Response/Body/itemCodeSearch:ItemCodeSearch/Item/carrier': $this->item['carrier'] = $text; break;
        // 商品名
        case '/Response/Body/itemCodeSearch:ItemCodeSearch/Item/itemName': $this->item['itemName'] = $text; break;
        // 商品コード
        case '/Response/Body/itemCodeSearch:ItemCodeSearch/Item/itemCode': $this->item['itemCode'] = $text; break;
        // 商品価格
        case '/Response/Body/itemCodeSearch:ItemCodeSearch/Item/itemPrice': $this->item['itemPrice'] = $text; break;
        // 商品説明文
        case '/Response/Body/itemCodeSearch:ItemCodeSearch/Item/itemCaption': $this->item['itemCaption'] = $text; break;
        // 商品URL
        case '/Response/Body/itemCodeSearch:ItemCodeSearch/Item/itemUrl': $this->item['itemUrl'] = $text; break;
        // アフィリエイトURL
        case '/Response/Body/itemCodeSearch:ItemCodeSearch/Item/affiliateUrl': $this->item['affiliateUrl'] = $text; break;
        // 商品画像有無フラグ
        case '/Response/Body/itemCodeSearch:ItemCodeSearch/Item/imageFlag': $this->item['imageFlag'] = $text; break;
        // 商品画像 64x64URL
        case '/Response/Body/itemCodeSearch:ItemCodeSearch/Item/smallImageUrl': $this->item['smallImageUrl'] = $text; break;
        // 商品画像 128x128URL
        case '/Response/Body/itemCodeSearch:ItemCodeSearch/Item/mediumImageUrl': $this->item['mediumImageUrl'] = $text; break;
        // 販売可能フラグ
        case '/Response/Body/itemCodeSearch:ItemCodeSearch/Item/availability': $this->item['availability'] = $text; break;
        // 消費税フラグ
        case '/Response/Body/itemCodeSearch:ItemCodeSearch/Item/taxFlag': $this->item['taxFlag'] = $text; break;
        // 送料フラグ
        case '/Response/Body/itemCodeSearch:ItemCodeSearch/Item/postageFlag': $this->item['postageFlag'] = $text; break;
        // クレジットカード利用可能フラグ
        case '/Response/Body/itemCodeSearch:ItemCodeSearch/Item/creditCardFlag': $this->item['creditCardFlag'] = $text; break;
        // ショップオブザイヤーフラグ
        case '/Response/Body/itemCodeSearch:ItemCodeSearch/Item/shopOfTheYearFlag': $this->item['shopOfTheYearFlag'] = $text; break;
        // アフィリエイト利用利率
        case '/Response/Body/itemCodeSearch:ItemCodeSearch/Item/affiliateRate': $this->item['affiliateRate'] = $text; break;
        // 販売開始時刻
        case '/Response/Body/itemCodeSearch:ItemCodeSearch/Item/startTime': $this->item['startTime'] = $text; break;
        // 販売終了時刻
        case '/Response/Body/itemCodeSearch:ItemCodeSearch/Item/endTime': $this->item['endTime'] = $text; break;
        // レビュー件数
        case '/Response/Body/itemCodeSearch:ItemCodeSearch/Item/reviewCount': $this->item['reviewCount'] = $text; break;
        // レビュー平均
        case '/Response/Body/itemCodeSearch:ItemCodeSearch/Item/reviewAverage': $this->item['reviewAverage'] = $text; break;
        // 店舗名
        case '/Response/Body/itemCodeSearch:ItemCodeSearch/Item/shopName': $this->item['shopName'] = $text; break;
        // 店舗コード
        case '/Response/Body/itemCodeSearch:ItemCodeSearch/Item/shopCode': $this->item['shopCode'] = $text; break;
        // 店舗URL
        case '/Response/Body/itemCodeSearch:ItemCodeSearch/Item/shopUrl': $this->item['shopUrl'] = $text; break;
        // ジャンルID
        case '/Response/Body/itemCodeSearch:ItemCodeSearch/Item/genreId': $this->item['genreId'] = $text; break;

        // 上記以外
        default: parent::getElement($current_path, $attribute, $text);
        }
    }

    /**
     * 商品情報を取得する
     *
     * @access public
     * @param string キー名
     * @return mixed 商品情報
     */
    function getItem($name=null)
    {
        if ($name !== null) {
            return isset($this->item[$name]) ? $this->item[$name] : null;
        } else {
            return $this->item;
        }
    }
}
