<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceLivedoor_com.php,v 1.1 2009/01/11 05:34:30 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBサービスリクエストクラス（Livedoor）
 */
require_once dirname(__FILE__) . '/Livedoor_com/SyL_WebServiceLivedoor_comRequest.php';
/**
 * WEBサービスレスポンスクラス（Livedoor）
 */
require_once dirname(__FILE__) . '/Livedoor_com/SyL_WebServiceLivedoor_comResponse.php';

/**
 * WEBサービスクラス（Livedoor用）
 *
 * 詳細は、Weather Hacks（気象データ配信サービス）参照
 *   http://weather.livedoor.com/weather_hacks/
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceLivedoor_com.php,v 1.1 2009/01/11 05:34:30 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_WebServiceLivedoor_com extends SyL_WebService
{
    // -----------------------------------------------------
    // お天気Webサービス
    // -----------------------------------------------------

    /**
     * WEBサービスリクエストオブジェクトを作成する（お天気Webサービス用）
     * 
     * @access public
     * @return object WEBサービスリクエストオブジェクト（お天気Webサービス用）
     */
    function &createWeatherRequest()
    {
        $class_name = 'SyL_WebServiceWeatherRequest';
        include_once dirname(__FILE__) . '/Livedoor_com/Weather/' . $class_name . '.php';
        $request =& new $class_name();
        return $request;
    }
}
