<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceCategorySearchRequest.php,v 1.1 2009/01/11 05:34:31 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBサービスレスポンスクラス（Yahoo! Japan - ディレクトリサーチ用）
 */
require_once 'SyL_WebServiceCategorySearchResponse.php';

/**
 * WEBサービスリクエストクラス（Yahoo! Japan - ディレクトリサーチ用）
 *
 * 詳細は、Yahoo!デベロッパーネットワーク参照
 *   http://developer.yahoo.co.jp/
 * ディレクトリサーチ
 *   http://developer.yahoo.co.jp/category/search/V1/search.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceCategorySearchRequest.php,v 1.1 2009/01/11 05:34:31 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_WebServiceCategorySearchRequest extends SyL_WebServiceYahoo_co_jpRequest
{
    /**
     * WEBサービスサーバーのホスト名
     *
     * @access protected
     * @var string
     */
    var $host = 'dir.yahooapis.jp';
    /**
     * 実行URLパス
     *
     * @access protected
     * @var string
     */
    var $path = '/Category/V1/directorySearch';
    /**
     * レスポンスクラス名
     *
     * @access protected
     * @var string
     */
    var $response_class = 'SyL_WebServiceCategorySearchResponse';

    /**
     * 検索クエリーをセットする
     *
     * @access public
     * @param string 検索クエリー
     */
    function setQuery($query)
    {
        parent::set('query', $query);
    }

    /**
     * カテゴリ取得区分をセットする
     *
     * @access public
     * @param int カテゴリ取得区分
     */
    function setType($type)
    {
        switch ((string)$type) {
        case '0': // カテゴリデータとサイトデータ。
        case '1': // カテゴリデータのみ。
        case '2': // サイトデータのみ。
            parent::set('type', $type);
            break;
        default:
            trigger_error("[SyL error] Invalid `type' property ($type) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 返却結果の数をセットする
     *
     * @access public
     * @param int 返却結果の数
     */
    function setResults($results)
    {
        if (preg_match('/^\d+$/', $results) && (($results >= 0) && ($results <= 50))) {
            parent::set('results', $results);
        } else {
            trigger_error("[SyL error] Invalid `results' property ($results) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 返却結果の先頭位置をセットする
     *
     * @access public
     * @param int 返却結果の先頭位置
     */
    function setStart($start)
    {
        if (preg_match('/^\d+$/', $start)) {
            $results = isset($this->parameters['results']) ? $this->parameters['results'] : 10;
            if (($start + $results - 1) <= 1000) {
                parent::set('start', $start);
            } else {
                trigger_error("[SyL error] Invalid `start' property ($start) in `" . __CLASS__ . "' class", E_USER_ERROR);
            }
        } else {
            trigger_error("[SyL error] Invalid `start' property ($start) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * アダルトコンテンツの検索結果を含めるかどうかをセットする
     *
     * @access public
     * @param int アダルトコンテンツの検索結果を含めるかどうか
     */
    function setAdult_ok($adult_ok)
    {
        $adult_ok = ($adult_ok) ? '1' : '';
        parent::set('adult_ok', $adult_ok);
    }

    /**
     * カテゴリページのURLから「http://dir.yahoo.co.jp」を除いた部分をセットする
     *
     * @access public
     * @param string カテゴリページのURLから「http://dir.yahoo.co.jp」を除いた部分
     */
    function setPath($path)
    {
        parent::set('path', $path);
    }

    /**
     * 1週間以内に登録されたカテゴリや登録サイトとするかをセットする
     *
     * @access public
     * @param int 1週間以内に登録されたカテゴリや登録サイトとするか
     */
    function setNew($new)
    {
        $new = ($new) ? '1' : '0';
        parent::set('new', $new);
    }

    /**
     * 「新着情報」の「今週のオススメ」に掲載された登録サイトのみとするかをセットする
     *
     * @access public
     * @param int 「新着情報」の「今週のオススメ」に掲載された登録サイトのみとするか
     */
    function setPicks($picks)
    {
        $picks = ($picks) ? '1' : '0';
        parent::set('picks', $picks);
    }
}
