<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceJlpFuriganaServiceResponse.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBサービスレスポンスクラス（Yahoo! Japan - ルビ振りWebサービス）
 *
 * 詳細は、Yahoo!デベロッパーネットワーク参照
 *   http://developer.yahoo.co.jp/
 * ルビ振りWebサービス
 *   http://developer.yahoo.co.jp/jlp/FuriganaService/V1/furigana.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceJlpFuriganaServiceResponse.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_WebServiceJlpFuriganaServiceResponse extends SyL_WebServiceYahoo_co_jpResponse
{
    /**
     * 単語のリスト
     *
     * @access private
     * @var array
     */
     var $results = array();

    /**
     * XMLデータ内容取得ハンドラメソッド
     *
     * @access protected
     * @param string 現在XML解析中のパス
     * @param string XMLのタグの属性値
     * @param string XMLのタグの値
     */
    function getElement($current_path, $attribute, $text)
    {
        static $i = -1;
        static $j = -1;

        switch ($current_path) {
        // =============================
        // 正常系
        // =============================
        // 単語
        case '/ResultSet/Result/WordList/Word': $i++; break;
        // 単語の表記
        case '/ResultSet/Result/WordList/Word/Surface': $this->results[$i]['Surface'] = $text; break;
        // 単語のよみをひらがな
        case '/ResultSet/Result/WordList/Word/Furigana': $this->results[$i]['Furigana'] = $text; break;
        // 単語のよみをローマ字
        case '/ResultSet/Result/WordList/Word/Roman': $this->results[$i]['Roman'] = $text; break;
        // さらに細かく漢字部分とひらがな部分に分割した結果のリスト
        case '/ResultSet/Result/WordList/Word/SubWordList': $this->results[$i]['SubWordList'] = array(); $j = -1; break;
        // 漢字部分とひらがな部分に分割した結果
        case '/ResultSet/Result/WordList/Word/SubWordList/SubWord': $j++; break;
        // 単語の表記
        case '/ResultSet/Result/WordList/Word/SubWordList/SubWord/Surface': $this->results[$i]['SubWordList'][$j]['Surface'] = $text; break;
        // 単語のよみをひらがな
        case '/ResultSet/Result/WordList/Word/SubWordList/SubWord/Furigana': $this->results[$i]['SubWordList'][$j]['Furigana'] = $text; break;
        // 単語のよみをローマ字
        case '/ResultSet/Result/WordList/Word/SubWordList/SubWord/Roman': $this->results[$i]['SubWordList'][$j]['Roman'] = $text; break;

        // その他
        default: parent::getElement($current_path, $attribute, $text); break;
        }
    }

    /**
     * 単語のリストを取得
     *
     * @access public
     * @return array 単語のリスト
     */
    function getResults()
    {
        return $this->results;
    }
}
