<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceJlpJIMServiceResponse.php,v 1.1 2009/01/11 05:34:32 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBサービスレスポンスクラス（Yahoo! Japan - かな漢字変換Webサービス）
 *
 * 詳細は、Yahoo!デベロッパーネットワーク参照
 *   http://developer.yahoo.co.jp/
 * かな漢字変換Webサービス
 *   http://developer.yahoo.co.jp/jlp/JIMService/V1/conversion.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceJlpJIMServiceResponse.php,v 1.1 2009/01/11 05:34:32 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_WebServiceJlpJIMServiceResponse extends SyL_WebServiceYahoo_co_jpResponse
{
    /**
     * 校正結果
     *
     * @access private
     * @var array
     */
     var $results = array();

    /**
     * XMLデータ内容取得ハンドラメソッド
     *
     * @access protected
     * @param string 現在XML解析中のパス
     * @param string XMLのタグの属性値
     * @param string XMLのタグの値
     */
    function getElement($current_path, $attribute, $text)
    {
        static $i = -1;

        switch ($current_path) {
        // =============================
        // 正常系
        // =============================
        case '/ResultSet/Result/SegmentList/Segment': $i++; break;
        // 文節ごとの読みにあたる文字列
        case '/ResultSet/Result/SegmentList/Segment/SegmentText': $this->results[$i]['SegmentText'] = $text; break;
        // 全角英数字の変換結果
        case '/ResultSet/Result/SegmentList/Segment/Alphanumeric': $this->results[$i]['Alphanumeric'] = $text; break;
        // 半角英数字の変換結果
        case '/ResultSet/Result/SegmentList/Segment/HalfAlphanumeric': $this->results[$i]['HalfAlphanumeric'] = $text; break;
        // 全角カタカナの変換結果
        case '/ResultSet/Result/SegmentList/Segment/Katakana': $this->results[$i]['Katakana'] = $text; break;
        // 半角カタカナの変換結果
        case '/ResultSet/Result/SegmentList/Segment/HalfKatakana': $this->results[$i]['HalfKatakana'] = $text; break;
        // 全角ひらがなの変換結果
        case '/ResultSet/Result/SegmentList/Segment/Hiragana': $this->results[$i]['Hiragana'] = $text; break;
        // 変換候補
        case '/ResultSet/Result/SegmentList/Segment/CandidateList': $this->results[$i]['CandidateList'] = array(); break;
        case '/ResultSet/Result/SegmentList/Segment/CandidateList/Candidate': $this->results[$i]['CandidateList'][] = $text; break;

        // その他
        default: parent::getElement($current_path, $attribute, $text); break;
        }
    }


    /**
     * 変換候補取得結果
     *
     * @access public
     * @return array 変換候補取得結果
     */
    function getResults()
    {
        return $this->results;
    }
}
