<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceJlpMAServiceRequest.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBサービスレスポンスクラス（Yahoo! Japan - 日本語形態素解析Webサービス）
 */
require_once 'SyL_WebServiceJlpMAServiceResponse.php';

/**
 * WEBサービスリクエストクラス（Yahoo! Japan - 日本語形態素解析Webサービス）
 *
 * 詳細は、Yahoo!デベロッパーネットワーク参照
 *   http://developer.yahoo.co.jp/
 * 日本語形態素解析Webサービス
 *   http://developer.yahoo.co.jp/jlp/MAService/V1/parse.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceJlpMAServiceRequest.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_WebServiceJlpMAServiceRequest extends SyL_WebServiceYahoo_co_jpRequest
{
    /**
     * WEBサービスサーバーのホスト名
     *
     * @access protected
     * @var string
     */
    var $host = 'jlp.yahooapis.jp';
    /**
     * 実行URLパス
     *
     * @access protected
     * @var string
     */
    var $path = '/MAService/V1/parse';
    /**
     * レスポンスクラス名
     *
     * @access protected
     * @var string
     */
    var $response_class = 'SyL_WebServiceJlpMAServiceResponse';

    /**
     * 解析対象のテキストをセットする
     *
     * @access public
     * @param string 解析対象のテキスト
     */
    function setSentence($sentence)
    {
        parent::set('sentence', $sentence);
    }

    /**
     * 解析結果の種類をセットする
     *
     * @access public
     * @param string 解析結果の種類
     */
    function setResults($results)
    {
        foreach (array_map('trim', explode(',', $results)) as $tmp) {
            switch ($tmp) {
            case 'ma':
            case 'uniq':
                break;
            default:
                trigger_error("[SyL error] Invalid `results' property ({$results}) in `" . __CLASS__ . "' class", E_USER_ERROR);
            }
        }
        parent::set('results', $results);
    }

    /**
     * ma_response, uniq_response のデフォルト設定をセットする
     *
     * @access public
     * @param string ma_response, uniq_response のデフォルト設定
     */
    function setResponse($response)
    {
        foreach (array_map('trim', explode(',', $response)) as $tmp) {
            switch ($tmp) {
            case 'surface':
            case 'reading':
            case 'pos':
            case 'baseform':
            case 'feature':
                break;
            default:
                trigger_error("[SyL error] Invalid `response' property ({$response}) in `" . __CLASS__ . "' class", E_USER_ERROR);
            }
        }
        parent::set('response', $response);
    }

    /**
     * ma_filter, uniq_filter のデフォルト設定をセットする
     *
     * @access public
     * @param string ma_filter, uniq_filter のデフォルト設定
     */
    function setFilter($filter)
    {
        foreach (array_map('trim', explode('|', $filter)) as $tmp) {
            switch ($tmp) {
            case '1':
            case '2':
            case '3':
            case '4':
            case '5':
            case '6':
            case '7':
            case '8':
            case '9':
            case '10':
            case '11':
            case '12':
            case '13':
                break;
            default:
                trigger_error("[SyL error] Invalid `filter' property ({$filter}) in `" . __CLASS__ . "' class", E_USER_ERROR);
            }
        }
        parent::set('filter', $filter);
    }

    /**
     * ma_result 内の word に返される形態素情報をセットする
     *
     * @access public
     * @param string ma_result 内の word に返される形態素情報
     */
    function setMa_response($ma_response)
    {
        foreach (array_map('trim', explode(',', $ma_response)) as $tmp) {
            switch ($tmp) {
            case 'surface':
            case 'reading':
            case 'pos':
            case 'baseform':
            case 'feature':
                break;
            default:
                trigger_error("[SyL error] Invalid `ma_response' property ({$ma_response}) in `" . __CLASS__ . "' class", E_USER_ERROR);
            }
        }
        parent::set('ma_response', $ma_response);
    }

    /**
     * ma_result 内に解析結果として出力する品詞番号をセットする
     *
     * @access public
     * @param string ma_result 内に解析結果として出力する品詞番号
     */
    function setMa_filter($ma_filter)
    {
        foreach (array_map('trim', explode('|', $ma_filter)) as $tmp) {
            switch ($tmp) {
            case '1':
            case '2':
            case '3':
            case '4':
            case '5':
            case '6':
            case '7':
            case '8':
            case '9':
            case '10':
            case '11':
            case '12':
            case '13':
                break;
            default:
                trigger_error("[SyL error] Invalid `ma_filter' property ({$ma_filter}) in `" . __CLASS__ . "' class", E_USER_ERROR);
            }
        }
        parent::set('ma_filter', $ma_filter);
    }

    /**
     * uniq_result 内の word に返される形態素情報をセットする
     *
     * @access public
     * @param string uniq_result 内の word に返される形態素情報
     */
    function setUniq_response($uniq_response)
    {
        foreach (array_map('trim', explode(',', $uniq_response)) as $tmp) {
            switch ($tmp) {
            case 'surface':
            case 'reading':
            case 'pos':
            case 'baseform':
            case 'feature':
                break;
            default:
                trigger_error("[SyL error] Invalid `uniq_response' property ({$uniq_response}) in `" . __CLASS__ . "' class", E_USER_ERROR);
            }
        }
        parent::set('uniq_response', $uniq_response);
    }

    /**
     * uniq_result 内に解析結果として出力する品詞番号をセットする
     *
     * @access public
     * @param string uniq_result 内に解析結果として出力する品詞番号
     */
    function setUniq_filter($uniq_filter)
    {
        foreach (array_map('trim', explode('|', $uniq_filter)) as $tmp) {
            switch ($tmp) {
            case '1':
            case '2':
            case '3':
            case '4':
            case '5':
            case '6':
            case '7':
            case '8':
            case '9':
            case '10':
            case '11':
            case '12':
            case '13':
                break;
            default:
                trigger_error("[SyL error] Invalid `uniq_filter' property ({$uniq_filter}) in `" . __CLASS__ . "' class", E_USER_ERROR);
            }
        }
        parent::set('uniq_filter', $uniq_filter);
    }

    /**
     * 基本形の同一性をセットする
     *
     * @access public
     * @param bool 基本形の同一性
     */
    function setUniq_by_baseform($uniq_by_baseform)
    {
        $uniq_by_baseform = ($uniq_by_baseform) ? 'true' : 'false';
        parent::set('uniq_by_baseform', $uniq_by_baseform);
    }
}
