<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceJlpMAServiceResponse.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBサービスレスポンスクラス（Yahoo! Japan - 日本語形態素解析Webサービス）
 *
 * 詳細は、Yahoo!デベロッパーネットワーク参照
 *   http://developer.yahoo.co.jp/
 * 日本語形態素解析Webサービス
 *   http://developer.yahoo.co.jp/jlp/MAService/V1/parse.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceJlpMAServiceResponse.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_WebServiceJlpMAServiceResponse extends SyL_WebServiceYahoo_co_jpResponse
{
    /**
     * 形態素の総数
     *
     * @access private
     * @var int
     */
     var $ma_total_count = 0;
    /**
     * フィルタにマッチした形態素数
     *
     * @access private
     * @var int
     */
     var $ma_filtered_count = 0;
    /**
     * 形態素のリスト
     *
     * @access private
     * @var string
     */
     var $ma_word_list = array();
    /**
     * 形態素の総数（同一形態素）
     *
     * @access private
     * @var int
     */
     var $uniq_total_count = 0;
    /**
     * フィルタにマッチした形態素数（同一形態素）
     *
     * @access private
     * @var int
     */
     var $uniq_filtered_count = 0;
    /**
     * 形態素のリスト（同一形態素）
     *
     * @access private
     * @var string
     */
     var $uniq_word_list = array();

    /**
     * XMLデータ内容取得ハンドラメソッド
     *
     * @access protected
     * @param string 現在XML解析中のパス
     * @param string XMLのタグの属性値
     * @param string XMLのタグの値
     */
    function getElement($current_path, $attribute, $text)
    {
        static $ma_i   = -1;
        static $uniq_i = -1;

        switch ($current_path) {
        // =============================
        // 正常系
        // =============================
        // 形態素の総数
        case '/ResultSet/ma_result/total_count': $this->ma_total_count = $text; break;
        // フィルタにマッチした形態素数
        case '/ResultSet/ma_result/filtered_count': $this->ma_filtered_count = $text; break;
        // 形態素
        case '/ResultSet/ma_result/word_list/word': $ma_i++; break;
        // 形態素の表記
        case '/ResultSet/ma_result/word_list/word/surface': $this->ma_word_list[$ma_i]['surface'] = $text; break;
        // 形態素の読みがな
        case '/ResultSet/ma_result/word_list/word/reading': $this->ma_word_list[$ma_i]['reading'] = $text; break;
        // 形態素の品詞
        case '/ResultSet/ma_result/word_list/word/pos': $this->ma_word_list[$ma_i]['pos'] = $text; break;
        // 形態素の基本形表記
        case '/ResultSet/ma_result/word_list/word/baseform': $this->ma_word_list[$ma_i]['baseform'] = $text; break;

        // 形態素の総数（同一形態素）
        case '/ResultSet/uniq_result/total_count': $this->uniq_total_count = $text; break;
        // フィルタにマッチした形態素数（同一形態素）
        case '/ResultSet/uniq_result/filtered_count': $this->uniq_filtered_count = $text; break;
        // 形態素（同一形態素）
        case '/ResultSet/uniq_result/word_list/word': $uniq_i++; break;
        // 形態素の表記（同一形態素）
        case '/ResultSet/uniq_result/word_list/word/surface': $this->uniq_word_list[$uniq_i]['surface'] = $text; break;
        // 形態素の読みがな（同一形態素）
        case '/ResultSet/uniq_result/word_list/word/reading': $this->uniq_word_list[$uniq_i]['reading'] = $text; break;
        // 形態素の品詞（同一形態素）
        case '/ResultSet/uniq_result/word_list/word/pos': $this->uniq_word_list[$uniq_i]['pos'] = $text; break;
        // 形態素の基本形表記（同一形態素）
        case '/ResultSet/uniq_result/word_list/word/baseform': $this->uniq_word_list[$uniq_i]['baseform'] = $text; break;
        // uniq_result 中の word 内に現れる、形態素の出現数
        case '/ResultSet/uniq_result/word_list/word/count': $this->uniq_word_list[$uniq_i]['count'] = $text; break;

        // その他
        default: parent::getElement($current_path, $attribute, $text); break;
        }
    }

    /**
     * 形態素の総数を取得
     *
     * @access public
     * @return int 形態素の総数
     */
    function getMaTotalCount()
    {
        return $this->ma_total_count;
    }

    /**
     * フィルタにマッチした形態素数を取得
     *
     * @access public
     * @return int フィルタにマッチした形態素数
     */
    function getMaFilteredCount()
    {
        return $this->ma_filtered_count;
    }

    /**
     * 形態素のリストを取得
     *
     * @access public
     * @return array 形態素のリスト
     */
    function getMaWordList()
    {
        return $this->ma_word_list;
    }

    /**
     * 形態素の総数を取得（同一形態素）
     *
     * @access public
     * @return int 形態素の総数
     */
    function getUniqTotalCount()
    {
        return $this->uniq_total_count;
    }

    /**
     * フィルタにマッチした形態素数を取得（同一形態素）
     *
     * @access public
     * @return int フィルタにマッチした形態素数
     */
    function getUniqFilteredCount()
    {
        return $this->uniq_filtered_count;
    }

    /**
     * 形態素のリストを取得（同一形態素）
     *
     * @access public
     * @return array 形態素のリスト
     */
    function getUniqWordList()
    {
        return $this->uniq_word_list;
    }
}
