<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceMapLocalSearchResponse.php,v 1.1 2009/01/11 05:34:32 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBサービスレスポンスクラス（Yahoo! Japan - 地図情報 - ローカルサーチAPI）
 *
 * 詳細は、Yahoo!デベロッパーネットワーク参照
 *   http://developer.yahoo.co.jp/
 * 地図情報 - ローカルサーチAPI
 *   http://developer.yahoo.co.jp/map/localsearch/V1/localsearch.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceMapLocalSearchResponse.php,v 1.1 2009/01/11 05:34:32 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_WebServiceMapLocalSearchResponse extends SyL_WebServiceYahoo_co_jpResponse
{
    /**
     * 検索一致件数
     *
     * @access private
     * @var int
     */
     var $count = 0;
    /**
     * 検索出力件数
     *
     * @access private
     * @var int
     */
     var $view_count = 0;
    /**
     * 検索キーワード
     *
     * @access private
     * @var string
     */
     var $query = null;
    /**
     * 地図に関する情報
     *
     * @access private
     * @var array
     */
    var $items = array();

    /**
     * XMLデータ内容取得ハンドラメソッド
     *
     * @access protected
     * @param string 現在XML解析中のパス
     * @param string XMLのタグの属性値
     * @param string XMLのタグの値
     */
    function getElement($current_path, $attribute, $text)
    {
        static $item_i = -1;

        switch ($current_path) {
        // =============================
        // 正常系
        // =============================
        // 検索一致件数
        case '/LocalSearchResult/Count': $this->count = $text; break;
        // 検索出力件数
        case '/LocalSearchResult/ViewCount': $this->view_count = $text; break;
        // 検索キーワード
        case '/LocalSearchResult/Query': $this->query = $text; break;

        // 地図に関する情報
        case '/LocalSearchResult/Item':  $item_i++; break;
        // 検索カテゴリ
        case '/LocalSearchResult/Item/Category': $this->items[$item_i]['Category'] = $text; break;
        // 名称
        case '/LocalSearchResult/Item/Title': $this->items[$item_i]['Title'] = $text; break;
        // 住所
        case '/LocalSearchResult/Item/Address': $this->items[$item_i]['Address'] = $text; break;
        // 住所レベル
        case '/LocalSearchResult/Item/AddressLevel': $this->items[$item_i]['AddressLevel'] = $text; break;
        // 日本測地系緯度経度
        case '/LocalSearchResult/Item/DatumTky97': $this->items[$item_i]['DatumTky97'] = array(); break;
        // 日本測地系緯度経度 - 緯度（10進形式） 
        case '/LocalSearchResult/Item/DatumTky97/Lat': $this->items[$item_i]['DatumTky97']['Lat'] = $text; break;
        // 日本測地系緯度経度 - 経度（10進形式）
        case '/LocalSearchResult/Item/DatumTky97/Lon': $this->items[$item_i]['DatumTky97']['Lon'] = $text; break;
        // 世界測地系経度経度
        case '/LocalSearchResult/Item/DatumWgs84': $this->items[$item_i]['DatumWgs84'] = array(); break;
        // 世界測地系経度経度 - 緯度（10進形式） 
        case '/LocalSearchResult/Item/DatumWgs84/Lat': $this->items[$item_i]['DatumWgs84']['Lat'] = $text; break;
        // 世界測地系経度経度 - 経度（10進形式）
        case '/LocalSearchResult/Item/DatumWgs84/Lon': $this->items[$item_i]['DatumWgs84']['Lon'] = $text; break;
        // 詳細ページへのURL
        case '/LocalSearchResult/Item/Url': $this->items[$item_i]['Url'] = $text; break;

        // その他
        default: parent::getElement($current_path, $attribute, $text); break;
        }
    }

    /**
     * 検索一致件数を取得
     *
     * @access public
     * @return int 検索一致件数
     */
    function getCount()
    {
        return $this->count;
    }

    /**
     * 検索出力件数を取得
     *
     * @access public
     * @return int 検索出力件数
     */
    function getViewCount()
    {
        return $this->view_count;
    }

    /**
     * 検索キーワードを取得
     *
     * @access public
     * @return string 検索キーワード
     */
    function getQuery()
    {
        return $this->query;
    }

    /**
     * 地図に関する情報を取得する
     *
     * @access public
     * @return array 地図に関する情報
     */
    function getItems()
    {
        return $this->items;
    }
}
