<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceMinnaCertCertDetailResponse.php,v 1.1 2009/01/11 05:34:32 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBサービスレスポンスクラス（Yahoo! Japan - みんなの検定 検定詳細Webサービス）
 *
 * 詳細は、Yahoo!デベロッパーネットワーク参照
 *   http://developer.yahoo.co.jp/
 * みんなの検定 検定詳細Webサービス
 *   http://developer.yahoo.co.jp/minna_cert/certdetail/V1/certdetail.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceMinnaCertCertDetailResponse.php,v 1.1 2009/01/11 05:34:32 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_WebServiceMinnaCertCertDetailResponse extends SyL_WebServiceYahoo_co_jpResponse
{
    /**
     * データ内のマッチしたクエリー数
     *
     * @access private
     * @var int 
     */
     var $total_results_available = 0;
    /**
     * 返却され、かつマッチしたクエリーの数
     *
     * @access private
     * @var int 
     */
    var $total_results_returned = 0;
    /**
     * 全検索結果の最初のポジション
     *
     * @access private
     * @var int 
     */
    var $first_result_position = 0;
    /**
     * 検定データ配列
     *
     * @access private
     * @var array
     */
    var $result = array();
    /**
     * 問題データ配列
     *
     * @access private
     * @var array
     */
    var $questions = array();

    /**
     * XMLデータ内容取得ハンドラメソッド
     *
     * @access protected
     * @param string 現在XML解析中のパス
     * @param string XMLのタグの属性値
     * @param string XMLのタグの値
     */
    function getElement($current_path, $attribute, $text)
    {
        static $i   = -1;
        static $q_i = -1;

        switch ($current_path) {
        // =============================
        // 正常系
        // =============================
        case '/ResultSet':
            if (isset($attribute['totalResultsAvailable'])) {
                $this->total_results_available = $attribute['totalResultsAvailable'];
            }
            if (isset($attribute['totalResultsReturned'])) {
                $this->total_results_returned = $attribute['totalResultsReturned'];
            }
            if (isset($attribute['firstResultPosition'])) {
                $this->first_result_position = $attribute['firstResultPosition'];
            }
            break;
        // 検定のID
        case '/ResultSet/Result/CertId': $this->result['CertId'] = $text; break;
        // 検定名
        case '/ResultSet/Result/CertName': $this->result['CertName'] = $text; break;
        // 検定区分
        case '/ResultSet/Result/CertDiv': $this->result['CertDiv'] = $text; break;
        // 検定作成者
        case '/ResultSet/Result/UserName': $this->result['UserName'] = $text; break;
        // 検定画像のURL
        case '/ResultSet/Result/CertImageUrl': $this->result['CertImageUrl'] = $text; break;
        // 検定概要
        case '/ResultSet/Result/CertOverview': $this->result['CertOverview'] = $text; break;
        // 検定の公開日
        case '/ResultSet/Result/OpenDate': $this->result['OpenDate'] = $text; break;
        // 問題数
        case '/ResultSet/Result/QuestionCount': $this->result['QuestionCount'] = $text; break;
        // 検定レポート公開フラグ
        case '/ResultSet/Result/ReportOpenFlag': $this->result['ReportOpenFlag'] = $text; break;
        // 合格基準
        case '/ResultSet/Result/Correct': $this->result['Correct'] = $text; break;
        // 受験者総数
        case '/ResultSet/Result/ExamAmount': $this->result['ExamAmount'] = $text; break;
        // 合格者総数
        case '/ResultSet/Result/PassAmount': $this->result['PassAmount'] = $text; break;
        // お気に入りの検定に登録した利用者の数
        case '/ResultSet/Result/FavoredCertCount': $this->result['FavoredCertCount'] = $text; break;
        // 投稿されたコメント数
        case '/ResultSet/Result/CommentCount': $this->result['CommentCount'] = $text; break;
        // 評価ポイントの平均値
        case '/ResultSet/Result/EvalPoint': $this->result['EvalPoint'] = $text; break;
        // 検定の総合ポイント
        case '/ResultSet/Result/TotalPoint': $this->result['TotalPoint'] = $text; break;
        // パソコン版の検定詳細ページのURL
        case '/ResultSet/Result/CertDetailPcUrl': $this->result['CertDetailPcUrl'] = $text; break;
        // モバイル版の検定詳細ページのURL
        case '/ResultSet/Result/CertDetailMbUrl': $this->result['CertDetailMbUrl'] = $text; break;

        case '/ResultSet/Result/QuestionResult/QuestionData': $i++; break;
        // 問題ID
        case '/ResultSet/Result/QuestionResult/QuestionData/QuestionId': $this->questions[$i]['QuestionId'] = $text; break;
        // 出題番号
        case '/ResultSet/Result/QuestionResult/QuestionData/OrderNumber': $this->questions[$i]['OrderNumber'] = $text; break;
        // 問題文
        case '/ResultSet/Result/QuestionResult/QuestionData/QuestionText': $this->questions[$i]['QuestionText'] = $text; break;
        // 問題画像（Mサイズ）のURL
        case '/ResultSet/Result/QuestionResult/QuestionData/QuestionImageMUrl': $this->questions[$i]['QuestionImageMUrl'] = $text; break;
        // 問題画像（Sサイズ）のURL
        case '/ResultSet/Result/QuestionResult/QuestionData/QuestionImageSUrl': $this->questions[$i]['QuestionImageSUrl'] = $text; break;
        // 問題動画のURL
        case '/ResultSet/Result/QuestionResult/QuestionData/QuestionMovieUrl': $this->questions[$i]['QuestionMovieUrl'] = $text; break;
        // 問題に正解した人の総数
        case '/ResultSet/Result/QuestionResult/QuestionData/CorrectCount': $this->questions[$i]['CorrectCount'] = $text; break;
        // 問題を未解答とした人の総数
        case '/ResultSet/Result/QuestionResult/QuestionData/NoAnswerCount': $this->questions[$i]['NoAnswerCount'] = $text; break;
        // 正解選択肢番号
        case '/ResultSet/Result/QuestionResult/QuestionData/CorrectAnswer': $this->questions[$i]['CorrectAnswer'] = $text; break;
        // 解説文
        case '/ResultSet/Result/QuestionResult/QuestionData/QuestionExplanation': $this->questions[$i]['QuestionExplanation'] = $text; break;
        // 解説画像（Mサイズ）のURL
        case '/ResultSet/Result/QuestionResult/QuestionData/ExplanationImageMUrl': $this->questions[$i]['ExplanationImageMUrl'] = $text; break;
        // 解説画像（Sサイズ）のURL
        case '/ResultSet/Result/QuestionResult/QuestionData/ExplanationImageSUrl': $this->questions[$i]['ExplanationImageSUrl'] = $text; break;
        // 解説動画のURL
        case '/ResultSet/Result/QuestionResult/QuestionData/ExplanationMovieUrl': $this->questions[$i]['ExplanationMovieUrl'] = $text; break;

        // 選択肢情報
        case '/ResultSet/Result/QuestionResult/QuestionData/ChoicesResult':
            $this->questions[$i]['ChoicesResult'] = array();
            $q_i = -1;
            break;
        // 選択肢各情報
        case '/ResultSet/Result/QuestionResult/QuestionData/ChoicesResult/ChoiceData': $q_i++; break;
        // 選択肢番号
        case '/ResultSet/Result/QuestionResult/QuestionData/ChoicesResult/ChoiceData/OrderNumber': $this->questions[$i]['ChoicesResult'][$q_i]['OrderNumber'] = $text; break;
        // 選択肢
        case '/ResultSet/Result/QuestionResult/QuestionData/ChoicesResult/ChoiceData/ChoiceText': $this->questions[$i]['ChoicesResult'][$q_i]['ChoiceText'] = $text; break;
        // 選択肢に設定されている配点
        case '/ResultSet/Result/QuestionResult/QuestionData/ChoicesResult/ChoiceData/ChoicePoint': $this->questions[$i]['ChoicesResult'][$q_i]['ChoicePoint'] = $text; break;
        // 選択肢の選択者数
        case '/ResultSet/Result/QuestionResult/QuestionData/ChoicesResult/ChoiceData/ChoiceCount': $this->questions[$i]['ChoicesResult'][$q_i]['ChoiceCount'] = $text; break;

        // その他
        default: parent::getElement($current_path, $attribute, $text); break;
        }
    }

    /**
     * データ内のマッチしたクエリー数を取得する
     *
     * @access public
     * @return int データ内のマッチしたクエリー数
     */
    function getTotalResultsAvailable()
    {
        return $this->total_results_available;
    }

    /**
     * 返却され、かつマッチしたクエリーの数を取得する
     *
     * @access public
     * @return int 返却され、かつマッチしたクエリーの数
     */
    function getTotalResultsReturned()
    {
        return $this->total_results_returned;
    }

    /**
     * 返却され、かつマッチしたクエリーの数を取得する
     *
     * @access public
     * @return int 返却され、かつマッチしたクエリーの数
     */
    function getFirstResultPosition()
    {
        return $this->first_result_position;
    }

    /**
     * 検定データを取得する
     *
     * @access public
     * @return array 検定データ配列
     */
    function getResult()
    {
        return $this->result;
    }

    /**
     * 問題データを取得する
     *
     * @access public
     * @return array 問題データ配列
     */
    function getQuestions()
    {
        return $this->questions;
    }
}
