<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceMinnaCertCertExamRequest.php,v 1.1 2009/01/11 05:34:29 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBサービスレスポンスクラス（Yahoo! Japan - みんなの検定 検定受験Webサービス）
 */
require_once 'SyL_WebServiceMinnaCertCertExamResponse.php';

/**
 * WEBサービスリクエストクラス（Yahoo! Japan - みんなの検定 検定受験Webサービス）
 *
 * 詳細は、Yahoo!デベロッパーネットワーク参照
 *   http://developer.yahoo.co.jp/
 * みんなの検定 検定受験Webサービス
 *   http://developer.yahoo.co.jp/minna_cert/certexam/V1/certexam.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceMinnaCertCertExamRequest.php,v 1.1 2009/01/11 05:34:29 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_WebServiceMinnaCertCertExamRequest extends SyL_WebServiceYahoo_co_jpRequest
{
    /**
     * WEBサービスサーバーのホスト名
     *
     * @access protected
     * @var string
     */
    var $host = 'cert.yahooapis.jp';
    /**
     * 実行URLパス
     *
     * @access protected
     * @var string
     */
    var $path = '/MinnaCertWebService/V1/certExam';
    /**
     * レスポンスクラス名
     *
     * @access protected
     * @var string
     */
    var $response_class = 'SyL_WebServiceMinnaCertCertExamResponse';

    /**
     * 検定IDをセットする
     *
     * @access public
     * @param int 検定ID
     */
    function setCert_id($cert_id)
    {
        if (preg_match('/^\d+$/', $cert_id)) {
            parent::set('cert_id', $cert_id);
        } else {
            trigger_error("[SyL error] Invalid `cert_id' property ({$cert_id}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 問題IDを出題番号順に","（カンマ）で連結した文字列をセットする
     *
     * @access public
     * @param string 問題IDを出題番号順に","（カンマ）で連結した文字列
     */
    function setQid($qid)
    {
        parent::set('qid', $qid);
    }

    /**
     * 各問題の解答を","（カンマ）で連結した文字列をセットする
     *
     * @access public
     * @param string 各問題の解答を","（カンマ）で連結した文字列
     */
    function setAnswer($answer)
    {
        parent::set('answer', $answer);
    }
}
