<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceMinnaCertCertListRequest.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBサービスレスポンスクラス（Yahoo! Japan - みんなの検定 検定リストWebサービス）
 */
require_once 'SyL_WebServiceMinnaCertCertListResponse.php';

/**
 * WEBサービスリクエストクラス（Yahoo! Japan - みんなの検定 検定リストWebサービス）
 *
 * 詳細は、Yahoo!デベロッパーネットワーク参照
 *   http://developer.yahoo.co.jp/
 * みんなの検定 検定リストWebサービス
 *   http://developer.yahoo.co.jp/minna_cert/certlist/V1/certlist.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceMinnaCertCertListRequest.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_WebServiceMinnaCertCertListRequest extends SyL_WebServiceYahoo_co_jpRequest
{
    /**
     * WEBサービスサーバーのホスト名
     *
     * @access protected
     * @var string
     */
    var $host = 'cert.yahooapis.jp';
    /**
     * 実行URLパス
     *
     * @access protected
     * @var string
     */
    var $path = '/MinnaCertWebService/V1/certList';
    /**
     * レスポンスクラス名
     *
     * @access protected
     * @var string
     */
    var $response_class = 'SyL_WebServiceMinnaCertCertListResponse';

    /**
     * 利用者に対応するURL文字列をセットする
     *
     * @access public
     * @param string 利用者に対応するURL文字列
     */
    function setUserstr($userstr)
    {
        parent::set('userstr', $userstr);
    }

    /**
     * 検索クエリーをセットする
     *
     * @access public
     * @param string 検索クエリー
     */
    function setKeyword($keyword)
    {
        parent::set('keyword', $keyword);
    }

    /**
     * 検索種別をセットする
     *
     * @access public
     * @param int 検索種別
     */
    function setExtract($extract)
    {
        switch ((string)$extract) {
        case '0': // キーワード検索
        case '1': // タグ検索
            parent::set('extract', $extract);
            break;
        default:
            trigger_error("[SyL error] Invalid `extract' property ({$extract}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 並べ替え条件をセットする
     *
     * @access public
     * @param int 並べ替え条件
     */
    function setOrder($order)
    {
        switch ((string)$order) {
        case '1': // 公開日降順
        case '2': // 総合ポイント
        case '3': // 受験者数
        case '4': // 検定名
            parent::set('order', $order);
            break;
        default:
            trigger_error("[SyL error] Invalid `order' property ({$order}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 返却結果の先頭位置をセットする
     *
     * @access public
     * @param int 返却結果の先頭位置
     */
    function setStart($start)
    {
        if (preg_match('/^\d+$/', $start) && ($start >= 1)) {
            parent::set('start', $start);
        } else {
            trigger_error("[SyL error] Invalid `start' property ({$start}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 返却結果の数をセットする
     *
     * @access public
     * @param int 返却結果の数
     */
    function setAmount($amount)
    {
        if (preg_match('/^\d+$/', $amount) && (($amount >= 1) && ($amount <= 50))) {
            parent::set('amount', $amount);
        } else {
            trigger_error("[SyL error] Invalid `amount' property ({$amount}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }
}
