<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceSearchWebResponse.php,v 1.1 2009/01/11 05:34:29 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBサービスレスポンスクラス（Yahoo! Japan - ウェブ検索用）
 *
 * 詳細は、Yahoo!デベロッパーネットワーク参照
 *   http://developer.yahoo.co.jp/
 * ウェブ検索
 *   http://developer.yahoo.co.jp/search/web/V1/webSearch.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceSearchWebResponse.php,v 1.1 2009/01/11 05:34:29 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_WebServiceSearchWebResponse extends SyL_WebServiceYahoo_co_jpResponse
{
    /**
     * データ内のマッチしたクエリー数
     *
     * @access private
     * @var int 
     */
     var $total_results_available = 0;
    /**
     * 返却され、かつマッチしたクエリーの数
     *
     * @access private
     * @var int 
     */
    var $total_results_returned = 0;
    /**
     * 全検索結果の最初のポジション
     *
     * @access private
     * @var int 
     */
    var $first_result_position = 0;
    /**
     * 検索結果データ配列
     *
     * @access private
     * @var array
     */
    var $results = array();

    /**
     * XMLデータ内容取得ハンドラメソッド
     *
     * @access protected
     * @param string 現在XML解析中のパス
     * @param string XMLのタグの属性値
     * @param string XMLのタグの値
     */
    function getElement($current_path, $attribute, $text)
    {
        static $i = -1;

        switch ($current_path) {
        // =============================
        // 正常系
        // =============================
        case '/ResultSet':
            if (isset($attribute['totalResultsAvailable'])) {
                $this->total_results_available = $attribute['totalResultsAvailable'];
            }
            if (isset($attribute['totalResultsReturned'])) {
                $this->total_results_returned = $attribute['totalResultsReturned'];
            }
            if (isset($attribute['firstResultPosition'])) {
                $this->first_result_position = $attribute['firstResultPosition'];
            }
            break;
        case '/ResultSet/Result': $i++; break;
        // ページのタイトル
        case '/ResultSet/Result/Title': $this->results[$i]['Title'] = $text; break;
        // ページに関連するテキストサマリー
        case '/ResultSet/Result/Summary': $this->results[$i]['Summary'] = $text; break;
        // ページのURL
        case '/ResultSet/Result/Url': $this->results[$i]['Url'] = $text; break;
        // ページのリンクURL
        case '/ResultSet/Result/ClickUrl': $this->results[$i]['ClickUrl'] = $text; break;
        // ページが最後に修正された日付
        case '/ResultSet/Result/ModificationDate': $this->results[$i]['ModificationDate'] = $text; break;
        // ページのMIMEタイプ
        case '/ResultSet/Result/MimeType': $this->results[$i]['MimeType'] = $text; break;
        // キャシュ結果
        case '/ResultSet/Result/Cache': $this->results[$i]['Cache'] = array(); break;
        // キャシュ結果のURL
        case '/ResultSet/Result/Cache/Url': $this->results[$i]['Cache']['Url'] = $text; break;
        // キャシュ結果のサイズ
        case '/ResultSet/Result/Cache/Size': $this->results[$i]['Cache']['Size'] = $text; break;

        // その他
        default: parent::getElement($current_path, $attribute, $text); break;
        }
    }

    /**
     * データ内のマッチしたクエリー数を取得する
     *
     * @access public
     * @return int データ内のマッチしたクエリー数
     */
    function getTotalResultsAvailable()
    {
        return $this->total_results_available;
    }

    /**
     * 返却され、かつマッチしたクエリーの数を取得する
     *
     * @access public
     * @return int 返却され、かつマッチしたクエリーの数
     */
    function getTotalResultsReturned()
    {
        return $this->total_results_returned;
    }

    /**
     * 返却され、かつマッチしたクエリーの数を取得する
     *
     * @access public
     * @return int 返却され、かつマッチしたクエリーの数
     */
    function getFirstResultPosition()
    {
        return $this->first_result_position;
    }

    /**
     * 検索結果データを取得する
     *
     * @access public
     * @return array 検索結果データ配列
     */
    function getResults()
    {
        return $this->results;
    }
}
