<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceShoppingCategorysearchResponse.php,v 1.1 2009/01/11 05:34:34 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBサービスレスポンスクラス（Yahoo! Japan - カテゴリID取得用）
 *
 * 詳細は、Yahoo!デベロッパーネットワーク参照
 *   http://developer.yahoo.co.jp/
 * カテゴリID取得
 *   http://developer.yahoo.co.jp/shopping/categorysearch/V1/categorySearch.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceShoppingCategorysearchResponse.php,v 1.1 2009/01/11 05:34:34 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_WebServiceShoppingCategorysearchResponse extends SyL_WebServiceYahoo_co_jpResponse
{
    /**
     * 返却され、かつマッチしたクエリーの数
     *
     * @access private
     * @var int 
     */
    var $total_results_returned = 0;
    /**
     * カテゴリデータ（カレント）
     *
     * @access private
     * @var array
     */
    var $categories_current = array();
    /**
     * カテゴリデータ（サブ要素）
     *
     * @access private
     * @var array
     */
    var $categories_children = array();

    /**
     * XMLデータ内容取得ハンドラメソッド
     *
     * @access protected
     * @param string 現在XML解析中のパス
     * @param string XMLのタグの属性値
     * @param string XMLのタグの値
     */
    function getElement($current_path, $attribute, $text)
    {
        static $i = -1;
        static $j = -1;

        switch ($current_path) {
        // =============================
        // 正常系
        // =============================
        case '/ResultSet':
            if (isset($attribute['totalResultsReturned'])) {
                $this->total_results_returned = $attribute['totalResultsReturned'];
            }
            break;

        // カテゴリデータ
        case '/ResultSet/Result/Categories/Current/Id':       $this->categories_current['Current']['Id']       = $text; break;
        case '/ResultSet/Result/Categories/Current/ParentId': $this->categories_current['Current']['ParentId'] = $text; break;
        case '/ResultSet/Result/Categories/Current/Url':      $this->categories_current['Current']['Url']      = $text; break;

        case '/ResultSet/Result/Categories/Current/Title/Short':  $this->categories_current['Current']['Title']['Short']  = $text; break;
        case '/ResultSet/Result/Categories/Current/Title/Medium': $this->categories_current['Current']['Title']['Medium'] = $text; break;
        case '/ResultSet/Result/Categories/Current/Title/Long':   $this->categories_current['Current']['Title']['Long']   = $text; break;

        case '/ResultSet/Result/Categories/Current/Path/Category':
            $i++;
            if (isset($attribute['depth'])) {
                $this->categories_current['Current']['Path']['Category'][$i]['_attributes']['depth'] = $attribute['depth'];
            }
            break;

        case '/ResultSet/Result/Categories/Current/Path/Category/Id':         $this->categories_current['Current']['Path']['Category'][$i]['Id'] = $text; break;
        case '/ResultSet/Result/Categories/Current/Path/Category/ParentId':   $this->categories_current['Current']['Path']['Category'][$i]['ParentId'] = $text; break;
        case '/ResultSet/Result/Categories/Current/Path/Category/Title/Name': $this->categories_current['Current']['Path']['Category'][$i]['Title']['Name'] = $text; break;

        case '/ResultSet/Result/Categories/Children/Child':
            $j++;
            if (isset($attribute['sortOrder'])) {
                $this->categories_children['Children']['Child'][$j]['_attributes']['sortOrder'] = $attribute['sortOrder'];
            }
            break;

        case '/ResultSet/Result/Categories/Children/Child/Id':  $this->categories_children['Children']['Child'][$j]['Id']  = $text; break;
        case '/ResultSet/Result/Categories/Children/Child/Url': $this->categories_children['Children']['Child'][$j]['Url'] = $text; break;

        case '/ResultSet/Result/Categories/Children/Child/Title/Short':  $this->categories_children['Children']['Child'][$j]['Title']['Short']  = $text; break;
        case '/ResultSet/Result/Categories/Children/Child/Title/Medium': $this->categories_children['Children']['Child'][$j]['Title']['Medium'] = $text; break;
        case '/ResultSet/Result/Categories/Children/Child/Title/Long':   $this->categories_children['Children']['Child'][$j]['Title']['Long']   = $text; break;

        // その他
        default: parent::getElement($current_path, $attribute, $text); break;
        }
    }

    /**
     * 返却され、かつマッチしたクエリーの数を取得する
     *
     * @access public
     * @return int 返却され、かつマッチしたクエリーの数
     */
    function getTotalResultsReturned()
    {
        return $this->total_results_returned;
    }

    /**
     * カテゴリ（カレント）データを取得する
     *
     * @access public
     * @return array カテゴリデータ配列
     */
    function getCategoriesCurrent()
    {
        return $this->categories_current;
    }

    /**
     * カテゴリ（サブ要素）データを取得する
     *
     * @access public
     * @return array カテゴリデータ配列
     */
    function getCategoriesChildren()
    {
        return $this->categories_children;
    }
}
