<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlRssReader2_0.php,v 1.1 2009/01/11 05:34:31 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * RSS 0.91リーダクラス
 */
require_once 'SyL_XmlRssReader0_91.php';

/**
 * RSS 2.0リーダクラス
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlRssReader2_0.php,v 1.1 2009/01/11 05:34:31 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_XmlRssReader2_0 extends SyL_XmlRssReader0_91
{
    /**
     * XMLデータ内容取得ハンドラメソッド
     *
     * @access protected
     * @param string 現在XML解析中のパス
     * @param string XMLのタグの属性値
     * @param string XMLのタグの値
     */
    function getElement($current_path, $attribute, $text)
    {
        // XML解析結果を取得
        switch ($current_path) {
        // -------------------------------------------------
        // ヘッダ
        // -------------------------------------------------
        case '/rss/channel/category':
            if (!isset($this->channel['category'])) {
                $this->channel['category']   = array();
                $this->channel['categories'] = array();
                $this->channel_attr['category']   = array();
                $this->channel_attr['categories'] = array();
            }
            $i = count($this->channel['categories']);

            $this->channel['categories'][$i] = $text;

            if (isset($attribute['domain'])) $this->channel_attr['categories'][$i]['domain'] = $attribute['domain'];
            if ($i == 0) {
                $this->channel['category']      = $this->channel['categories'][$i];
                $this->channel_attr['category'] = $this->channel_attr['categories'][$i];
            }
            break;
        case '/rss/channel/generator': $this->channel['generator'] = $text; break;
        case '/rss/channel/cloud':
            if (isset($attribute['domain'])) $this->channel_attr['cloud']['domain'] = $attribute['domain'];
            if (isset($attribute['port']))   $this->channel_attr['cloud']['port']   = $attribute['port'];
            if (isset($attribute['path']))   $this->channel_attr['cloud']['path']   = $attribute['path'];
            if (isset($attribute['registerProcedure'])) $this->channel_attr['cloud']['registerProcedure'] = $attribute['registerProcedure'];
            if (isset($attribute['protocol'])) $this->channel_attr['cloud']['protocol'] = $attribute['protocol'];
            break;
        case '/rss/channel/ttl': $this->channel['ttl'] = $text; break;

        // -------------------------------------------------
        // データ
        // -------------------------------------------------
        // RSS情報
        case '/rss/channel/item/author': $this->items[$this->item_count-1]['author'] = $text; break;
        case '/rss/channel/item/category':
            if (!isset($this->channel['category'])) {
                $this->items[$this->item_count-1]['category']   = array();
                $this->items[$this->item_count-1]['categories'] = array();
                $this->items_attr[$this->item_count-1]['category']   = array();
                $this->items_attr[$this->item_count-1]['categories'] = array();
            }
            $i = count($this->items[$this->item_count-1]['categories']);

            $this->items[$this->item_count-1]['categories'][$i] = $text;

            if (isset($attribute['domain'])) $this->items_attr[$this->item_count-1]['categories'][$i]['domain'] = $attribute['domain'];
            if ($i == 0) {
                $this->items[$this->item_count-1]['category']      = $this->items[$this->item_count-1]['categories'][$i];
                $this->items_attr[$this->item_count-1]['category'] = $this->items_attr[$this->item_count-1]['categories'][$i];
            }
            break;
        case '/rss/channel/item/comments':  $this->items[$this->item_count-1]['comments']  = $text; break;
        case '/rss/channel/item/enclosure':
            if (isset($attribute['url']))    $this->items_attr[$this->item_count-1]['enclosure']['url']    = $attribute['url'];
            if (isset($attribute['length'])) $this->items_attr[$this->item_count-1]['enclosure']['length'] = $attribute['length'];
            if (isset($attribute['type']))   $this->items_attr[$this->item_count-1]['enclosure']['type']   = $attribute['type'];
            break;
        case '/rss/channel/item/guid':
            $this->items[$this->item_count-1]['id']   = $text;
            $this->items[$this->item_count-1]['guid'] = $text;
            if (isset($attribute['isPermaLink'])) $this->items_attr[$this->item_count-1]['guid']['isPermaLink'] = $attribute['isPermaLink'];
            break;
        case '/rss/channel/item/pubDate':
            $this->items[$this->item_count-1]['pubDate'] = $text;
            $this->items[$this->item_count-1]['date']    = $this->convertDateTime($text);
            break;
        case '/rss/channel/item/source':
            $this->items[$this->item_count-1]['source'] = $text;
            if (isset($attribute['url'])) $this->items_attr[$this->item_count-1]['source']['url'] = $attribute['url'];
            break;

        default:
            // その他の要素は、ver.0.91を参照
            parent::getElement($current_path, $attribute, $text);
            break;
        }
    }
}
