<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlRssClientResponse.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * HTTPリクエスト結果クラス
 */
require_once dirname(__FILE__) . '/../../Http/SyL_HttpClientResponse.php';
/**
 * RSSリーダクラス
 */
require_once 'SyL_XmlRssReader.php';

/**
 * RSSリクエストレスポンスクラス
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlRssClientResponse.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_XmlRssClientResponse extends SyL_HttpClientResponse
{
    /**
     * RSS リーダーオブジェクト
     *
     * @access private
     * @var object
     */
    var $reader = null;

    /**
     * コンストラクタ
     * 
     * @access public
     * @param string リクエスト結果
     * @param string クライアントエンコード
     * @param string RSSバージョン
     */
    function SyL_XmlRssClientResponse($data, $client_encode='', $rss_version='')
    {
        parent::SyL_HttpClientResponse($data, $client_encode);
        $this->reader =& SyL_XmlRssReader::factory($this->body, $rss_version);
        if ($this->client_encode) {
            $this->reader->setClientEncode($this->client_encode);
        }
        $this->reader->parseXml();
    }

    /**
     * 指定したチャネルを取得する
     *
     * @access public
     * @return mixed 指定したチャネル
     */
    function getChannel($name)
    {
        return $this->reader->getChannel($name);
    }

    /**
     * 指定したチャネルの属性を取得する
     *
     * @access public
     * @param string 取得要素名
     * @param string 取得要素サブ名
     * @return array 指定したチャネルの属性
     */
    function getChannelAttr($name, $subname=null)
    {
        return $this->reader->getChannelAttr($name, $subname);
    }

    /**
     * 配信情報を取得する
     *
     * @access public
     * @return array 配信情報
     */
    function getItems()
    {
        return $this->reader->getItems();
    }

    /**
     * 配信情報の属性を取得する
     *
     * @access public
     * @param int 件数目
     * @param string 取得要素名
     * @param string 取得要素サブ名
     * @return array 配信情報の属性
     */
    function getItemAttr($index, $name, $subname=null)
    {
        return $this->reader->getItemAttr($index, $name, $subname);
    }

    /**
     * 配信情報数を取得する
     *
     * @access public
     * @return int 配信情報数
     */
    function getItemCount()
    {
        return $this->reader->getItemCount();
    }
}
