<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlRssWriterAtom1_0.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * Atom 1.0作成クラス
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlRssWriterAtom1_0.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_XmlRssWriterAtom1_0 extends SyL_XmlRssWriter
{
    /**
     * チャネル要素をセットする
     * 
     * @access public
     * @param string 要素名
     * @param string 要素値
     * @param array 属性配列
     */
    function setChannel($name, $value, $attributes=array())
    {
        // 抽象化名変換
        switch ($name) {
        case 'copyright':
            $name = 'rights';
            break;
        case 'language':
            $name = 'dc:language';
            break;
        case 'date':
            $name  = 'updated';
        case 'updated':
            $value = $this->convertDateTime($value);
            break;
        }
        parent::setChannel($name, $value, $attributes);
    }

    /**
     * 項目をセットする
     * 
     * @access public
     * @param string 要素名
     * @param string 要素値
     * @param array 属性配列
     */
    function addItem($values, $attributes=array())
    {
        // 抽象化名変換
        foreach (array_keys($values) as $name) {
            switch ($name) {
            case 'description':
                $values['content'] = $values[$name];
                unset($values[$name]);
                break;
            case 'date':
                $values['published'] = $this->convertDateTime($values[$name]);
                unset($values[$name]);
                break;
            case 'published':
                $values['published'] = $this->convertDateTime($values[$name]);
                break;
            case 'updated':
                $values['updated'] = $this->convertDateTime($values[$name]);
                break;
            case 'copyright':
                $values['rights'] = $values[$name];
                unset($values[$name]);
                break;
            }
        }
        parent::addItem($values, $attributes);
    }

    /**
     * RSS XMLを作成する
     * 
     * @access public
     */
    function createXml()
    {
        $this->addStartElement('feed',
          array(
            'xmlns'    => 'http://www.w3.org/2005/Atom',
            'xmlns:dc' => 'http://purl.org/dc/elements/1.1/'
          )
        );

        // フィード要素
        foreach ($this->channel as $i => $values) {
            $this->createRecursiveElements($values[0], $values[1], (isset($this->channel_attr[$i]) ? $this->channel_attr[$i] : array()));
        }

        // エントリー要素
        foreach ($this->items as $item) {
            $this->addStartElement('entry');
            foreach ($item as $name => $value) {
                $this->createRecursiveElements($name, $value);
            }
            $this->addEndElement();
        }

        $this->addEndElement();
    }

    /**
     * 時刻フォーマットを変換する
     *
     * 例）2007/03/12 00:00:00 -> 2007-03-12T00:00:00+0900
     *
     * @access public
     * @param string 変換前時刻
     * @return string 変換後時刻
     */
    function convertDateTime($datetime)
    {
        if (preg_match('/^([0-9]{4})[\-|\/]?([0-1][0-9])[\-|\/]?([0-3][0-9])[ ]*([0-2][0-9]:?[0-5][0-9]:?[0-5][0-9])?$/', trim($datetime))) {
            $timestamp = @strtotime($datetime);
            if ($timestamp) {
                $datetime = date('Y-m-d\TH:i:s+0900', $timestamp);
            }
        }
        return $datetime;
    }
}
