<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: Table.php,v 1.2 2009/01/11 05:34:31 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * DBクラス
 */
SyL_Loader::lib('DB');
/**
 * ファイル処理クラス
 */
SyL_Loader::lib('File');
SyL_Loader::lib('Filesystem');

/**
 * ADM用アクションフォームとDAO用テーブルクラスを作成するクラス
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: Table.php,v 1.2 2009/01/11 05:34:31 seasonstream Exp $
 * @link      http://syl.jp/
 */
class Table extends AppAction
{
    /**
     * メイン処理
     *
     * @access public
     * @param object データオブジェクト
     * @param object コンテキストオブジェクト
     */
    function execute(&$data, &$context)
    {
        $cmd =& $context->getConsole();

        $project_dir  = $data->geta('d', 0);
        $app_name     = $data->geta('w', 0);
        $class_name   = $data->geta('n', 0);
        $class_prefix = $data->geta('p', 0);
        $table_name   = $data->geta('t', 0);

        $cmd->stdout("  parameters checking...");

        // -------------------------------------------------
        // プロジェクトディレクトリチェック
        // -------------------------------------------------
        if (!is_dir($project_dir)) {
            trigger_error("[SyL error] Project directory (-d) not found", E_USER_ERROR);
            exit;
        }

        // -------------------------------------------------
        // アプリケーション名チェック
        // -------------------------------------------------
        $app_dir = '';
        if ($app_name) {
            $app_dir = "{$project_dir}/apps/{$app_name}"; 
            if (!is_dir($app_dir)) {
                trigger_error("[SyL error] Application directory not found ({$app_dir})", E_USER_ERROR);
                exit;
            }
        }

        // -------------------------------------------------
        // テーブル名チェック
        // -------------------------------------------------
        if (!$table_name) {
            trigger_error("[SyL error] Table name (-t) not found", E_USER_ERROR);
            exit;
        }

        // -------------------------------------------------
        // クラス名チェック
        // -------------------------------------------------
        $table_file = '';
        if (!$class_name) {
            $class_name = $table_name;
        }
        $table_file = "{$project_dir}/lib" . SyL_Loader::convertPath($class_name, $class_prefix);
        $table_dir = dirname($table_file);
        if (!is_dir($table_dir)) {
            if ($cmd->getInput('', "Table directory not found. create directory ? ({$table_dir}) [Y/n]:") != 'Y') {
                return;
            }
        } else if (file_exists($table_file)) {
            if ($cmd->getInput('', "Already table file exist. overwrite file ? ({$table_file}) [Y/n]:") != 'Y') {
                return;
            }
        }
        $table_class = SyL_Loader::convertClass($class_name, false, $class_prefix);

        // -------------------------------------------------
        // 設定ファイルチェック
        // -------------------------------------------------
        $project_config_file = $project_dir . '/config/defines.xml';
        $app_config_file     = '';
        if ($app_dir) {
            $cmd->stdout("  project or application config checking...");
            $app_config_file = $app_dir . '/config/defines.xml';
        } else {
            $cmd->stdout("  project config checking...");
        }

        if (!is_file($project_config_file)) {
            trigger_error("[SyL error] `defines.xml' not found in project directory({$project_config_file})", E_USER_ERROR);
        }

        // -------------------------------------------------
        // DB接続文字列の取得
        // -------------------------------------------------
        $connection_string = '';
        if ($app_dir) {
            $cmd->stdout("  project or application config `SYL_DB_DSN' getting...");
            $connection_string = $this->getConnectionString($project_config_file, $app_config_file);
        } else {
            $cmd->stdout("  project config `SYL_DB_DSN' getting...");
            $connection_string = $this->getConnectionString($project_config_file);
        }

        // -------------------------------------------------
        // テーブルスキーマ情報の取得
        // -------------------------------------------------
        $cmd->stdout("  table schema scaning...");
        list($table_columns, $table_primary, $table_uniques, $table_foreigns) = $this->getTableSchema($connection_string, $table_name);

        if (count($table_columns) == 0) {
            trigger_error("[SyL error] Table schema not found ({$table_name})", E_USER_ERROR);
        }

        // 大文字統一
        $table_primary = array_map('strtoupper', $table_primary);
        for ($i=0; $i<count($table_uniques); $i++) {
            $table_uniques[$i] = array_map('strtoupper', $table_uniques[$i]);
        }
        foreach (array_keys($table_foreigns) as $key) {
            $table_foreigns[$key] = array_change_key_case($table_foreigns[$key], CASE_UPPER);
            $table_foreigns[$key] = array_map('strtoupper', $table_foreigns[$key]);
        }

        // -------------------------------------------------
        // ディレクトリ作成
        // -------------------------------------------------
        if (!is_dir($table_dir)) {
            $cmd->stdout("  create directories...");
            SyL_Filesystem::createDirectory($table_dir, 0755);
        }

        // -------------------------------------------------
        // ファイル作成
        // -------------------------------------------------
        $cmd->stdout("  create file...");

        // テンプレートファイル
        $template_table_file = SYL_PROJECT_DIR . '/var/templates/Table.php';

        // テーブルファイル作成
        $cmd->stdout("  table template file {$template_table_file}");

        $cmd->stdout("    -> creating table class...");
        $table_class_source = $this->getTableClassSource($project_dir, $template_table_file, $table_name, $table_class, $table_columns, $table_primary, $table_uniques, $table_foreigns);

        $cmd->stdout("    -> generating table class file... {$table_file}");
        SyL_File::writeContents($table_file, $table_class_source);

        // -------------------------------------------------
        // 結果表示
        // -------------------------------------------------

        $cmd->stdout("");
        $cmd->stdout("--- Result ---");
        $cmd->stdout("  [project directory] {$project_dir}");
        $cmd->stdout("  [table name] {$table_name}");
        $cmd->stdout("  [table class] {$table_file}");
    }
}
