#!/bin/bash

# ===================================================================== #
# ΥġSyLASΥåץǡȤԤޤ                           #
# СեǧƤнԤޤ          #
#                                                                       #
# [README]                                                              #
# 1: postLDAPadminΥ󥹥ȡ뤵Ƥǥ쥯ȥ              #
# 2: ɥᥤ̾                                             #
# ===================================================================== #
# define version
VERSION="1.01"

# root桼ɤå
if [ $UID -ne 0 ]; then
  echo
  echo "Only a root user can update."
  exit 1
fi

# check args
while getopts f:s: OPT
do
  case ${OPT} in
    "p" ) FLG_P="TRUE" ; INST_DIR="${OPTARG}" ;;
    "d" ) FLG_D="TRUE" ; DOMAIN="${OPTARG}" ;;
     *  ) echo
          echo "Usage: ${0} -p [postLDAPadmin INSTALLDIR] -d [DOMAIN NAME]" 1>&2
          exit 1 ;;
  esac
done

if [ "${FLG_P}" != "TRUE" -o "${FLG_D}" != "TRUE" ]
then
  echo "Usage: ${0} -p [postLDAPadmin INSTALLDIR] -d [DOMAIN NAME]" 1>&2
  exit 1
fi



# Version check
if [ -e ${INST_DIR}/etc/plugins ];then
  # get current version number
  declare -i NOWVERSION=`grep 'SyLAS' ${INST_DIR}/etc/plugins |
                         awk '{ print $2 }' | sed "s/\.//g"`
  declare -i NEWVERSION=`echo ${VERSION} | sed "s/\.//g"`
  # compare version number
  if [ ${NOWVERSION} -ge ${NEWVERSION} ];then
    echo "SyLAS is the latest version already.(ver.${NOWVERSION})"
    exit 1
  fi
fi

##################
# start to update
##################
echo "Start updating SyLAS to ver.${VERSION}"

# delete old SyLAS
rm -rf ${INST_DIR}/htdocs/admin/sylas

# htdocs۲Ǻ
pushd ../htdocs

# mainե
cp -rp admin/sylas "$INST_DIR/htdocs/admin/"
cp admin/images/* "$INST_DIR/htdocs/admin/images/"

# 륷ȤԽ
cat admin/style.css >> "$INST_DIR/htdocs/admin/style.css"

# bin
popd

# lib۲Ǻ
pushd ../lib

# 饤֥
cp -p dglibsylas "$INST_DIR/lib/"

# bin
popd

# tmpl۲Ǻ
pushd ../tmpl

# ƥץ졼
cp -p * "$INST_DIR/tmpl/"

# bin
#popd

pushd ../etc
# åե뺹ؤ
# åե1Ԥɤ߹
while read line; do
    # åֹ
    msgNUM=`echo ${line} | awk 'BEGIN { FS="$"; } /\\$/{ print $1 }'`
    # ȹ($ޤޤʤ)򥹥å
    if [ -z "${msgNUM}" ]
    then
        continue
    fi
    # ɲýȽ
    if grep "^${msgNUM}\\$" ${INST_DIR}/etc/${DOMAIN}/msg_file > /dev/null 2>&1
    then
        # 
        sed -i -e "/${msgNUM}/c ${line}" ${INST_DIR}/etc/${DOMAIN}/msg_file
    else
        # ɲý
        echo ${line} >> "${INST_DIR}/etc/${DOMAIN}/msg_file"
    fi
done < msg_file

# bin
popd

# pluginsСե빹
if [ -e ${INST_DIR}/etc/plugins ];then
    sed -i -e "/SyLAS/c SyLAS	${VERSION}" ${INST_DIR}/etc/plugins
else
    cat <<EOF > ${INST_DIR}/etc/plugins
#*------------------------------------------------------*#
#* The List of installed plug-in(s).                    *#
#*                                                      *#
#* Written in following format.                         *#
#* (name) <tab> (version)                               *#
#*------------------------------------------------------*#
SyLAS	${VERSION}
EOF

fi
echo
echo "Updating is completed!"
exit 0
