<?php
/*
 * postLDAPadmin
 *
 * Copyright (C) 2006,2007 DesigNET, INC.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
/***********************************************************
 * оݥɲò
 *
 * $RCSfile: host.php,v $
 * $Revision: 1.3 $
 * $Date: 2014/07/16 03:58:45 $
 **********************************************************/
include_once("../../initial");
include_once("lib/dglibcommon");
include_once("lib/dglibpage");
include_once("lib/dglibsess");
include_once("lib/dglibsylas");

/********************************************************
 * ƥڡ
 ********************************************************/

define("TMPLFILE",              "host_add_del.tmpl");
define("OPERATION",             "Search host add_del");

define("SELECT_HOST_SQL",       "SELECT * FROM hosts;");
define("SELECT_SEARCHHOST_SQL", "SELECT * FROM search_hosts WHERE group_id=%s;");
define("INSERT_GROUP_SQL",   "INSERT INTO loggroup " .
                             "(group_name, log_id) VALUES (\"%s\", \"%s\");");
define("GET_GROUPID_SQL",    "SELECT group_id FROM loggroup where " .
                             "group_name=\"%s\";");


/*********************************************************
 * SetTag_for_FirstTime()
 *
 * ɽΥ
 *
 * []
 *       $tag               ֤
 *
 * [֤]
 *       TRUE               
 *       FALSE              
 *********************************************************/
function SetTag_for_FirstTime(&$tag)
{
    global $web_conf;
    global $msgarr;
    global $err_msg;
    global $log_msg;
 
    /* MySQL³ */
    $conn = MySQL_connect_server();
    if ($conn === FALSE) {
        return FALSE;
    }

    /* MySQL餹٤ƤΥۥȤ */
    $result = MySQL_exec_query($conn, SELECT_HOST_SQL);
    if ($result === FALSE) {
        mysqli_close($conn);
        return FALSE;
    }

    /* MySQLϿ줿٤ƤΥۥȾ˳Ǽ */
    MySQL_get_data($result, $all_hosts);

    /* Խ̤餭Ƥ硢Υ롼פ˴ޤޤۥȤ */
    if (isset($_POST["hostadd_del"])) {
        /* MySQL餹٤ƤθоݥۥȤ */
        $search_host_sql = sprintf(SELECT_SEARCHHOST_SQL, $_POST["group_id"]);
        $result = MySQL_exec_query($conn, $search_host_sql);
        if ($result === FALSE) {
            mysqli_close($conn);
            return FALSE;
        }

        /* MySQLϿ줿оݥۥȾ˳Ǽ */
        MySQL_get_data($result, $search_hosts);
    /* Ͽξ硢ꥹȤѰդƤ(Nortice) */
    } else {
        $search_hosts = array();
    }

    /* MySQLȤ³Ĥ */
    mysqli_close($conn);

    /* оݡоݥۥȥꥹȤ */
    $non_search = array();
    $search     = array();
    make_search_hosts($all_hosts, $search_hosts, $non_search, $search);

    /* html */
    make_hosts_option($non_search, $a_option);
    make_hosts_option($search, $s_option);

    $tag["<<ALL_HOST_OPTION>>"]     = $a_option;
    $tag["<<SEARCH_HOST_OPTION>>"]  = $s_option;

    /* hiddenκ */
    make_id_hidden($non_search, $a_hidden, "all_id");
    make_id_hidden($search, $s_hidden, "search_id");
    $tag["<<NON_SEARCH_ID_HIDDEN>>"]    = $a_hidden;
    $tag["<<SEARCH_ID_HIDDEN>>"]        = $s_hidden;

    return TRUE;
}

/**********************************************************
 * move_hosts()
 *
 * 岼줿ݤˡΥꥹȤ⤦ΥꥹȤ
 * ۥȤư롣
 *
 * []
 *       &$topList      ΥꥹȤۥȷ
 *                          (id => ۥ̾Ϣ)
 *       &$botList      ΥꥹȤۥȷ
 *                          (id => ۥ̾Ϣ)
 *
 * [֤]
 *       ʤ
 **********************************************************/
function move_hosts(&$topList, &$botList)
{
    /* ꥹȥܥåǼѿ */
    $newFrom = array();
    $newTo   = array();

    /* upܥ, downܥξб롣
     * fromtoءselectedư롣
     * downܥ󤬲줿Ȥϡ
     * fromhiddenϤǽۥ($_POST["all_id"])Ȥʤꡢ
     *   tohiddenϤ븡оݥۥ($_POST["search_id"])ˤʤ롣
     * upܥ󤬲줿ȤϤε */
    list($selected, $from, $to, $mode) = isset($_POST["down"]) ?
                          array("all_host", "all_id", "search_id", "down")
                        : array("search_host", "search_id", "all_id", "up");

    /* $_POSTͤɤå(顼) */
    $moveHosts = isset($_POST[$selected]) ? $_POST[$selected] : array();
    $fromHosts = isset($_POST[$from])     ? $_POST[$from]     : array();
    $toHosts   = isset($_POST[$to])       ? $_POST[$to]       : array();

    /* ưȤΥۥȥꥹȤľ
     * $fromHostsϡŤưۥȥꥹȤǼ
     * hiddenƤ */
    foreach ($fromHosts as $host) {
        /* ŤꥹȤ顢ưоݤФ */
        if (in_array($host, $moveHosts)) {
            continue;
        }
        /* HTMLˤϡ"id,ۥ̾" ηǵҤƤ */
        list($host_id, $host_name) = explode(",", $host);
        /* Τδؿ(make_hosts_optionʤ)˹碌 */
        $newFrom[$host_id] = $host_name;
    }

    /* ưΥۥȥꥹȤľ
     * $toHostshidden
     */
    foreach ($toHosts as $host) {
        list($host_id, $host_name) = explode(",", $host);
        $newTo[$host_id] = $host_name;
    }
    /* ưоݤưɲä */
    foreach ($moveHosts as $host) {
        list($host_id, $host_name) = explode(",", $host);
        $newTo[$host_id] = $host_name;
    }

    /* ⡼ɤ˹碌Ϥ줿ѿ($topList, $botList)
     * ޺岼ΥꥹȥܥåƤ򥻥å */
    list($topList, $botList) = $mode == "down" ? array($newFrom, $newTo)
                                               : array($newTo, $newFrom);

    return;
}


/**********************************************************
 * add_loggroup()
 * $_POST["fromADD"]ͤȤǡ١˿롼פ롣
 *
 * []
 *          &$group_name    ̤ɽå
 *
 * [֤]
 *          $group_id       Ͽ롼פID
 *          FALSE           SQL顼
 **********************************************************/
function add_loggroup(&$group_name)
{
    /* ۥɲò̤Ϥ줿롼̾ID */
    list($group_name, $log_id) = explode(",", $_POST["fromADD"]);

    /* MySQL³ */
    $conn = MySQL_connect_server();
    if ($conn === FALSE) {
        return FALSE;
    }
    /* MySQL˥롼פϿ */
    $ret = add_mod_loggroup($conn, INSERT_GROUP_SQL, 
                            $group_name, $log_id);
    if ($ret === FALSE) {
        return FALSE;
    }   

    /* MySQL顢Ͽ롼פID */
    $gid_sql = sprintf(GET_GROUPID_SQL, $group_name);
    $ret = get_data($gid_sql, &$data);
    if ($ret === FALSE) {
        return FALSE;
    }

    return $data[0]["group_id"];
}


/***********************************************************
 * 
 **********************************************************/

/*  */
$tag["<<TITLE>>"]                = "";
$tag["<<JAVASCRIPT>>"]           = "";
$tag["<<SK>>"]                   = "";
$tag["<<TOPIC>>"]                = "";
$tag["<<MESSAGE>>"]              = "";
$tag["<<TAB>>"]                  = "";
$tag["<<ALL_HOST_OPTION>>"]      = "";
$tag["<<SEARCH_HOST_OPTION>>"]   = "";
$tag["<<NAME_HIDDEN>>"]          = "";
$tag["<<SEARCH_ID_HIDDEN>>"]     = "";
$tag["<<NON_SEARCH_ID_HIDDEN>>"] = "";

/* ե롢ִեɹåå */
$ret = init();
if ($ret === FALSE) {
    result_log(OPERATION . ":NG:" . $log_msg);
    syserr_display();
    exit (1);
}

/***********************************************************
 * main
 **********************************************************/

/* 岼Υܥ󤬲줿Ȥ */
if (isset($_POST["up"]) || isset($_POST["down"])) {
    /* ꥹȤؤԤ */
    $non_search = array(); // ˡǽۥȡפ줿Τͤᤳ
    $search = array();     // ˡָоݥۥȡפ줿Τͤᤳ
    move_hosts(&$non_search, &$search);

    /*  */
    /* 쥯ȤΥץ */
    make_hosts_option($non_search, $a_option);
    make_hosts_option($search, $s_option);
    $tag["<<ALL_HOST_OPTION>>"]     = $a_option;
    $tag["<<SEARCH_HOST_OPTION>>"]  = $s_option;

    /* hiddenκ */
    make_id_hidden($non_search, $a_hidden, "all_id");
    make_id_hidden($search, $s_hidden, "search_id");
    $tag["<<NON_SEARCH_ID_HIDDEN>>"]    = $a_hidden;
    $tag["<<SEARCH_ID_HIDDEN>>"]        = $s_hidden;

/* Ͽܥ󤬲줿Ȥ */
} else if (isset($_POST["mod"])) {
    /* ϿΤȤȹΤȤǡ롼IDѤ */
    /* Ͽ(add.phpܤƤ) */
    if ($_POST["fromADD"] != "") {
        /* 롼פϿID */
        $group_id = add_loggroup($group_name);
        if ($group_id === FALSE) {
            result_log(OPERATION . ":NG:" . $log_msg);
            syserr_display();
            exit(1);
        }
        /* ̤ */
        $location = "index.php";
        /* Ͽλå򥻥å */
        $err_msg = sprintf($msgarr['28028'][SCREEN_MSG], $group_name);
        $log_msg = sprintf($msgarr['28028'][LOG_MSG], $group_name);
    /*  */
    } else {
        /* ̤ѾƤID */
        $group_id = $_POST["group_id"];
        /* ̤ */
        $location = "mod.php";
        /* λå򥻥å */
        $err_msg = $msgarr['28020'][SCREEN_MSG];
        $log_msg = $msgarr['28020'][LOG_MSG];
    }

    /* ǡ١Խ */
    if (!isset($_POST["search_id"]) || !is_array($_POST["search_id"])) {
        $_POST["search_id"] = array();
    }
    $ret = modify_search_host($_POST["search_id"], $group_id);
    if ($ret === FALSE) {
        result_log(OPERATION . ":NG:" . $log_msg);
        syserr_display();
        exit(1);
    }

    /* β̤ */
    result_log(OPERATION . ":OK:" . $log_msg);
    $sesskey = $_POST["sk"];
    $postval = array("group_id" => $group_id);
    post_location($location, $err_msg, $postval);
    exit(0);
/* ɽΤȤ */
} else {
    /* ꥹȤhidden򥻥å */
    $ret = SetTag_for_FirstTime($tag);
    if ($ret === FALSE) {
        result_log(OPERATION . ":NG:" . $log_msg);
        syserr_display();
        exit(1);
    }
}

/***********************************************************
 * ɽ
 **********************************************************/

/*   */
$javascript = <<<HERE
function sysSubmit(url) {
    document.form_main.action=url;
    document.form_main.submit();
}
HERE;

set_tag_common($tag, $javascript);
$tag["<<GROUP_ID>>"] = isset($_POST["group_id"]) ? $_POST["group_id"] : "";
/* ϿԽǰۤʤʬꤹ */
if (isset($_POST["fromADD"])) {
    /* Ͽξ */
    $tag["<<NEW_HOSTNAME>>"] = $_POST["fromADD"]; // Ͽۥ̾,ID
    $tag["<<BUTTON_NAME>>"]  = "add_btn"; // ܥ̾Ͽפˤ
    $tag["<<CANCEL>>"]       = "add.php"; // 󥻥ܥ
} else {
    /* Խξ */
    $tag["<<NEW_HOSTNAME>>"] = ""; // ԽǤϻѤʤ
    $tag["<<BUTTON_NAME>>"]  = "mod_btn"; // ܥֹ̾פˤ
    $tag["<<CANCEL>>"]       = "mod.php"; // 󥻥ܥ
}

/* ڡν */
$ret = display(TMPLFILE, $tag, array(), "", "");
if ($ret === FALSE) {
    result_log(OPERATION . ":NG:" . $log_msg);
    syserr_display();
    exit(1);
}

exit(0);
?>
