////////////////////////////////////////////////////////////////////////////
// CCmdOption 饹Υץơ
//
////////////////////////////////////////////////////////////////////////////

#include "CmdOption.h"

////////////////////////////////////////////////////////////////////////////
// /˴
////////////////////////////////////////////////////////////////////////////

CCmdOption::CCmdOption() :
	IsEnableFileNameFlg( false ),
	IsEnableInitLineFlg( false ),
	InitLine( 0 ),
	FileNameOption( "/file:" ),
	InitLineOption( "/line:" ),
	Arg0( "" )
{

}

CCmdOption::~CCmdOption()
{

}

////////////////////////////////////////////////////////////////////////////
// ᥽å
////////////////////////////////////////////////////////////////////////////

// ץꤹ
void CCmdOption::SetOption( int argc, char *argv[] )
{
	// ޥɥ饤Υץ᤹
	// ʤλǤϡXtʤɤѤץ̵ʤäƤ
	int i;
	char buf[ PATH_MAX + 1 ];
	const char *pErrMsg = "Failer to resolve path name of process.";

	if ( argc < 0 ) {
		fprintf( stderr, pErrMsg );
		Arg0 = "";
		return ;
	}

	// argv[0]ΰ򤹤
	if ( realpath( argv[0], buf ) == NULL ) {
		fprintf( stderr, pErrMsg );
		Arg0 = argv[0];
	}
	else {
		buf[ PATH_MAX ] = '\0';
		Arg0 = buf;
	}

	for ( int i = 1; i < argc; i++ ) {
		if ( strncasecmp( FileNameOption.c_str(), argv[i], FileNameOption.size() ) == 0 ) {
			FileName = argv[i] + FileNameOption.size();
			if ( !FileName.empty() )
				IsEnableFileNameFlg = true;
			continue;
		}
		if ( strncasecmp( InitLineOption.c_str(), argv[i], InitLineOption.size() ) == 0 ) {
			if ( strlen( argv[i] ) > InitLineOption.size() ) {
				InitLine = atoi( argv[i] + InitLineOption.size() );
				IsEnableInitLineFlg = true;
			}
			continue;
		}
		// ΥåȲǤʤϥե̾ȸʤ
		FileName = argv[i];
		IsEnableFileNameFlg = true;
	}
}

// ե̾ץͭݤ
bool CCmdOption::IsEnableFileName() const
{
	return IsEnableFileNameFlg;
}

// ե̾ץ
const string& CCmdOption::GetFileName() const
{
	return FileName;
}

// ֹ楪ץͭݤ
bool CCmdOption::IsEnableInitLine() const
{
	return IsEnableInitLineFlg;
}

// ֹ楪ץͤ
int CCmdOption::GetInitLine() const
{
	return InitLine;
}

// argv[0]ͤ򻲾
const string& CCmdOption::GetArg0() const
{
	return Arg0;
}
