////////////////////////////////////////////////////////////////////////////
// CGCMgr 饹Υץơ
//
////////////////////////////////////////////////////////////////////////////

#include "GCMgr.h"

using namespace NLangExt;

////////////////////////////////////////////////////////////////////////////
// /˴
////////////////////////////////////////////////////////////////////////////

CGCMgr::CGCMgr() :
	TabGC( NULL ),
	SelTabGC( NULL ),
	ClearGC( NULL ),
	CursorGC( NULL ),
	wgtDraw( NULL ),
	SelTextGC( NULL ),
	pTxtColorMgr( NULL ),
	FailtTextDrawGC( NULL )
{

}

CGCMgr::~CGCMgr()
{
	FreeGC();
}

////////////////////////////////////////////////////////////////////////////
// ᥽å
////////////////////////////////////////////////////////////////////////////

// GCι
// pTCMNULLβǽ
bool CGCMgr::CreateGC(
	Widget argpDraw,
	VClsPtr< CConfigInfo > pConf,
	const NLangExt::CTxtColorMgr *pTCM )
{
	Display *d = XtDisplay( argpDraw );

	wgtDraw = argpDraw;
	pTxtColorMgr = pTCM;

	FailtTextDrawGC = XCreateGC( d, XtWindow( wgtDraw ), 0, NULL );
	if ( NULL == FailtTextDrawGC ) goto ERR_EXIT;
	XSetForeground( d, FailtTextDrawGC, pConf->RefNormalTextF_Color() );
	XSetBackground( d, FailtTextDrawGC, pConf->RefNormalTextB_Color() );

	// ƥѣǣ
	vTextDrawGC.clear();
	if ( pTCM ) {
		bool wflg = false;
		int cnt = pTCM->GetColorCount();
		for ( int i = 0; i < cnt; i++ ) {
			GC wGC = XCreateGC( d, XtWindow( wgtDraw ), 0, NULL );
			if ( NULL == wGC ) {
				wflg = true;	// 
				break;
			}
			XSetForeground( d, wGC, pTCM->GetColor( i ) );
			XSetBackground( d, wGC, pConf->RefNormalTextB_Color() );
			vTextDrawGC.push_back( wGC );
		}
		if ( wflg ) {
			// Ⱦü˹ۤΤ˴
			for ( int i = 0; i < vTextDrawGC.size(); i++ )
				XFreeGC( d, vTextDrawGC[i] );
			vTextDrawGC.clear();
		}
		else {
			XFreeGC( d, FailtTextDrawGC );	// ʤ
			FailtTextDrawGC = NULL;
		}
	}

	// Tabʸѣǣ
	TabGC = XCreateGC( d, XtWindow( wgtDraw ), 0, NULL );
	if ( NULL == TabGC ) goto ERR_EXIT;

	XSetForeground( d, TabGC, pConf->RefNormalTextB_Color() );
	XSetBackground( d, TabGC, pConf->RefNormalTextF_Color() );

	// 򤵤줿Tabѣǣ
	SelTabGC = XCreateGC( d, XtWindow( wgtDraw ), 0, NULL );
	if ( NULL == SelTabGC ) goto ERR_EXIT;

	XSetForeground( d, SelTabGC, pConf->RefSelectedTextB_Color() );
	XSetBackground( d, SelTabGC, pConf->RefSelectedTextF_Color() );

	// 򤵤줿ƥȤ
	SelTextGC = XCreateGC( d, XtWindow( wgtDraw ), 0, NULL );
	if ( NULL == SelTextGC ) goto ERR_EXIT;

	XSetForeground( d, SelTextGC, pConf->RefSelectedTextF_Color() );
	XSetBackground( d, SelTextGC, pConf->RefSelectedTextB_Color() );

	// ̤ξõѣǣ
	ClearGC = XCreateGC( d, XtWindow( wgtDraw ), 0, NULL );
	if ( NULL == ClearGC ) goto ERR_EXIT;

	XSetForeground( d, ClearGC, pConf->RefBackgroundColor() );
	XSetBackground( d, ClearGC, pConf->RefBackgroundColor() );

	// ѣǣ
	CursorGC = XCreateGC( d, XtWindow( wgtDraw ), 0, NULL );
	if ( NULL == CursorGC ) goto ERR_EXIT;
	XSetForeground( d, CursorGC, pConf->RefCursorColor() );
	XSetBackground( d, CursorGC, pConf->RefCursorColor() );
	XSetFunction( d, CursorGC, GXxor );	// XOR

	return true;

ERR_EXIT:
	FreeGC();
	return false;
}

// GC˴
void CGCMgr::FreeGC()
{
	int i;
	if ( wgtDraw ) {
		if ( FailtTextDrawGC )
			XFreeGC( XtDisplay( wgtDraw ), FailtTextDrawGC );
		for ( i = 0; i < vTextDrawGC.size(); i++ )
			XFreeGC( XtDisplay( wgtDraw ), vTextDrawGC[i] );
		if ( TabGC )
			XFreeGC( XtDisplay( wgtDraw ), TabGC );
		if ( SelTabGC )
			XFreeGC( XtDisplay( wgtDraw ), SelTabGC );
		if ( ClearGC )
			XFreeGC( XtDisplay( wgtDraw ), ClearGC );
		if ( CursorGC )
			XFreeGC( XtDisplay( wgtDraw ), CursorGC );
		if( SelTextGC )
			XFreeGC( XtDisplay( wgtDraw ), SelTextGC );
	}
	FailtTextDrawGC = NULL;
	vTextDrawGC.clear();
	TabGC = NULL;
	SelTabGC = NULL;
	ClearGC = NULL;
	CursorGC = NULL;
	wgtDraw = NULL;
	SelTextGC = NULL;
	pTxtColorMgr = NULL;
}

// ƥGC
GC CGCMgr::GetTextDrawGC( unsigned char c, bool IsSelected, bool IsTab ) const
{
	if ( !IsTab ) {
		if ( IsSelected )
			return SelTextGC;
		else {
			if ( !vTextDrawGC.empty() && pTxtColorMgr )
				return vTextDrawGC[ pTxtColorMgr->TranseToIdx( c ) ];
			else
				return FailtTextDrawGC;
		}
	}
	else {
		if ( IsSelected )
			return SelTabGC;
		else
			return TabGC;
	}
}

// TabʸGC
GC CGCMgr::GetTabGC() const
{
	return TabGC;
}

GC CGCMgr::GetSelTabGC() const
{
	return SelTabGC;
}

// طʾõGCμ
GC CGCMgr::GetClearGC() const
{
	return ClearGC;
}

// GCμ
GC CGCMgr::GetCursorGC() const
{
	return CursorGC;
}
