////////////////////////////////////////////////////////////////////////////
// PluginFunc.cc ץ饰󶡤뵡ǽ
//
////////////////////////////////////////////////////////////////////////////

#include "PluginFunc.h"
#include "PluginFuncID.h"
#include "Plugin.h"
#include "TaEditShell.h"
#include "CompoundStr.h"

PFT_BOOL PFunc_GetChar( unsigned long argLP, unsigned long argCP, wchar_t *pC );
PFT_BOOL PFunc_SetChar( unsigned long argLP, unsigned long argCP, wchar_t c );
PFT_BOOL PFunc_GetString( unsigned long argSLP, unsigned long argSCP, unsigned long argELP, unsigned long argECP, wchar_t *pBuf, unsigned long BufLength );
PFT_BOOL PFunc_Replace( unsigned long argSLP, unsigned long argSCP, unsigned long argELP, unsigned long argECP, const wchar_t *pBuf );
PFT_BOOL PFunc_GetLineCount( unsigned long *pCnt );
PFT_BOOL PFunc_GetCharCount( unsigned long argLP, unsigned long *pCnt );
PFT_BOOL PFunc_GetCursorPosition( unsigned long *pLP, unsigned long *pCP );
PFT_BOOL PFunc_SetCursorPosition( unsigned long LP, unsigned long CP );
PFT_BOOL PFunc_GetSelectionRange( unsigned long *argSLP, unsigned long *argSCP, unsigned long *argELP, unsigned long *argECP );
PFT_BOOL PFunc_SetSelectionRange( unsigned long argSLP, unsigned long argSCP, unsigned long argELP, unsigned long argECP );
const wchar_t* PFunc_GetConfigValue( const wchar_t *pName );
const char* PFunc_GetFileName();
void PFunc_ShowInformationMsgBox( const wchar_t *pMsg );
int PFunc_ShowQuestionMsgBox( const wchar_t *pMsg, PFT_BOOL ShowCancel );
void PFunc_ShowErrorMsgBox( const wchar_t *pMsg );
PFT_BOOL PFunc_GetModifiedFlg();

// ؿΥɥ쥹
void* GetFunctionAddress( unsigned int ID )
{
	switch ( ID ) {
	case PFID_GETCHAR:
		return reinterpret_cast< void* >( PFunc_GetChar );
	case PFID_SETCHAR:
		return reinterpret_cast< void* >( PFunc_SetChar );
	case PFID_GETSTRING:
		return reinterpret_cast< void* >( PFunc_GetString );
	case PFID_REPLACE:
		return reinterpret_cast< void* >( PFunc_Replace );
	case PFID_GETLINECOUNT:
		return reinterpret_cast< void* >( PFunc_GetLineCount );
	case PFID_GETCHARCOUNT:
		return reinterpret_cast< void* >( PFunc_GetCharCount );
	case PFID_GETCURSORPOSITION:
		return reinterpret_cast< void* >( PFunc_GetCursorPosition );
	case PFID_SETCURSORPOSITION:
		return reinterpret_cast< void* >( PFunc_SetCursorPosition );
	case PFID_GETSELECTIONRANGE:
		return reinterpret_cast< void* >( PFunc_GetSelectionRange );
	case PFID_SETSELECTIONRANGE:
		return reinterpret_cast< void* >( PFunc_SetSelectionRange );
	case PFID_GETCONFIGVALUE:
		return reinterpret_cast< void* >( PFunc_GetConfigValue );
	case PFID_GETFILENAME:
		return reinterpret_cast< void* >( PFunc_GetFileName );
	case PFID_SHOWINFORMATIONMSGBOX:
		return reinterpret_cast< void* >( PFunc_ShowInformationMsgBox );
	case PFID_SHOWQUESTIONMSGBOX:
		return reinterpret_cast< void* >( PFunc_ShowQuestionMsgBox );
	case PFID_SHOWERRORMSGBOX:
		return reinterpret_cast< void* >( PFunc_ShowErrorMsgBox );
	case PFID_GETMODIFIEDFLG:
		return reinterpret_cast< void* >( PFunc_GetModifiedFlg );
	}
	return NULL;
}

// ꤷ֤ʸ
PFT_BOOL PFunc_GetChar( unsigned long argLP, unsigned long argCP, wchar_t *pC )
{
	if ( NULL == pC ) return PFT_FALSE;
	const CTaEditDoc *pDoc = m_TaEditShell->GetDocument();
	if ( NULL == pDoc ) return PFT_FALSE;
		const T_LineData& rData = pDoc->RefData();
	if ( argLP < 0 || argLP >= rData.size() ) return PFT_FALSE;
	if ( argCP < 0 || argCP > rData[ argLP ].length() ) return PFT_FALSE;
	if ( argCP < rData[ argLP ].length() )
		(*pC) = pDoc->RefData()[ argLP ][ argCP ].moji;
	else
		(*pC) = L'\n';
	return PFT_TRUE;
}

// ꤷʸִ
PFT_BOOL PFunc_SetChar( unsigned long argLP, unsigned long argCP, wchar_t c )
{
	return PFT_FALSE;
}

// ꤵ줿ϰϤʸ
PFT_BOOL PFunc_GetString( unsigned long argSLP, unsigned long argSCP, unsigned long argELP, unsigned long argECP, wchar_t *pBuf, unsigned long BufLength )
{
	if ( NULL == pBuf ) return PFT_FALSE;
	if ( BufLength <= 0 ) return PFT_TRUE;
	const CTaEditDoc *pDoc = m_TaEditShell->GetDocument();
	if ( NULL == pDoc ) return PFT_FALSE;
	const T_LineData& rData = pDoc->RefData();
	if ( argSLP < 0 || argSLP >= rData.size() ) return PFT_FALSE;
	if ( argSCP < 0 || argSCP > rData[ argSLP ].length() ) return PFT_FALSE;
	if ( argELP < 0 || argELP >= rData.size() ) return PFT_FALSE;
	if ( argECP < 0 || argECP > rData[ argELP ].length() ) return PFT_FALSE;
	const wchar_t *ep = pBuf + BufLength - 1;
	wchar_t *wp = pBuf;
	unsigned long wcp = argSCP;
	unsigned long wlp = argSLP;

	while ( ( wlp < argELP || wlp == argELP && wcp < argECP ) && wp < ep ) {
		if ( wcp < rData[wlp].length() ) {
			(*wp) = rData[ wlp ][ wcp ].moji;
			wcp++;
		}
		else {
			(*wp) = L'\n';
			wcp = 0;
			wlp++;
		}
		wp++;
	}
	(*wp) = L'\0';
	return PFT_TRUE;
}

// ꤷϰϤʸִ
PFT_BOOL PFunc_Replace( unsigned long argSLP, unsigned long argSCP, unsigned long argELP, unsigned long argECP, const wchar_t *pBuf )
{
	if ( NULL == pBuf ) return PFT_FALSE;
	const CTaEditDoc *pDoc = m_TaEditShell->GetDocument();
	if ( NULL == pDoc ) return PFT_FALSE;
	const T_LineData& rData = pDoc->RefData();
	if ( argSLP < 0 || argSLP >= rData.size() ) return PFT_FALSE;
	if ( argSCP < 0 || argSCP > rData[ argSLP ].length() ) return PFT_FALSE;
	if ( argELP < 0 || argELP >= rData.size() ) return PFT_FALSE;
	if ( argECP < 0 || argECP > rData[ argELP ].length() ) return PFT_FALSE;
	CPlugin &rPlugin = m_TaEditShell->RefPluginMgr();

	T_SelRange Range = T_SelRange( T_CurPos( argSLP, argSCP ), T_CurPos( argELP, argECP ) );
	if ( rPlugin.Replace( Range, pBuf ) )
		return PFT_TRUE;
	else
		return PFT_FALSE;
}

// Կ
PFT_BOOL PFunc_GetLineCount( unsigned long *pCnt )
{
	if ( NULL == pCnt ) return PFT_FALSE;
	const CTaEditDoc *pDoc = m_TaEditShell->GetDocument();
	if ( NULL == pDoc ) return PFT_FALSE;
	(*pCnt) = pDoc->RefData().size();
	return PFT_TRUE;
}

// ꤷԤʸ
PFT_BOOL PFunc_GetCharCount( unsigned long argLP, unsigned long *pCnt )
{
	if ( NULL == pCnt ) return PFT_FALSE;
	const CTaEditDoc *pDoc = m_TaEditShell->GetDocument();
	if ( NULL == pDoc ) return PFT_FALSE;
	if ( argLP < 0 || argLP >= pDoc->RefData().size() ) return PFT_FALSE;
	(*pCnt) = pDoc->RefData()[ argLP ].length();
	if ( argLP < pDoc->RefData().size() - 1 )
		(*pCnt)++;	// βԥɤޤ
	return PFT_TRUE;
}

// ߤΥ֤
PFT_BOOL PFunc_GetCursorPosition( unsigned long *pLP, unsigned long *pCP )
{
	if ( !( pLP && pCP ) ) return PFT_FALSE;
	const T_CurPos& rCurPos = m_TaEditShell->RefPluginMgr().GetCurPos();
	(*pLP) = rCurPos.GetLine();
	(*pCP) = rCurPos.GetCPos();
	return PFT_TRUE;
}

// ֤
PFT_BOOL PFunc_SetCursorPosition( unsigned long LP, unsigned long CP )
{
	CPlugin &rPlugin = m_TaEditShell->RefPluginMgr();
	if ( rPlugin.SetCurPos_SelRange( T_CurPos( LP, CP ), rPlugin.GetSelRange() ) )
		return PFT_TRUE;
	else
		return PFT_FALSE;
}

// ߤϰϤ
PFT_BOOL PFunc_GetSelectionRange( unsigned long *argSLP, unsigned long *argSCP, unsigned long *argELP, unsigned long *argECP )
{
	if ( !( argSLP && argSCP && argELP && argECP ) ) return PFT_FALSE;
	const T_SelRange& rSelRange = m_TaEditShell->RefPluginMgr().GetSelRange();
	(*argSLP) = rSelRange.GetSPos().GetLine();
	(*argSCP) = rSelRange.GetSPos().GetCPos();
	(*argELP) = rSelRange.GetEPos().GetLine();
	(*argECP) = rSelRange.GetEPos().GetCPos();
	return PFT_TRUE;
}

// ϰϤ
PFT_BOOL PFunc_SetSelectionRange( unsigned long argSLP, unsigned long argSCP, unsigned long argELP, unsigned long argECP )
{
	CPlugin &rPlugin = m_TaEditShell->RefPluginMgr();
	T_SelRange selrange( T_CurPos( argSLP, argSCP ), T_CurPos( argELP, argECP ) );
	if ( rPlugin.SetCurPos_SelRange( rPlugin.GetCurPos(), selrange ) )
		return PFT_TRUE;
	else
		return PFT_FALSE;
}

// ̾б
const wchar_t* PFunc_GetConfigValue( const wchar_t *pName )
{
	if ( NULL == pName ) return NULL;
	return m_TaEditShell->RefPluginMgr().GetCurPluginConfig( pName );
}

// ե̾
const char* PFunc_GetFileName()
{
	return m_TaEditShell->GetDocument()->GetFileName().c_str();
}

// åܥåɽ
void PFunc_ShowInformationMsgBox( const wchar_t *pMsg )
{
	if ( NULL == pMsg ) return ;
	CCompoundStr str( pMsg );
	m_TaEditShell->ShowInformationMsgBox( str );
}

// åܥåɽ
// ShowCancel : ˤ硢֥󥻥ץܥɽ롣
// ֤͡Ϥפ줿1
// ֤פξ2
// ֥󥻥פξ3
// 顼ξ0
int PFunc_ShowQuestionMsgBox( const wchar_t *pMsg, PFT_BOOL ShowCancel )
{
	if ( NULL == pMsg ) return 0;
	CCompoundStr str( pMsg );
	return m_TaEditShell->ShowQuestionMsgBox( str, ShowCancel ? true : false );
}

// 顼åܥåɽ
void PFunc_ShowErrorMsgBox( const wchar_t *pMsg )
{
	if ( NULL == pMsg ) return ;
	CCompoundStr str( pMsg );
	m_TaEditShell->ShowErrorMsgBox( str );
}

// ѹե饰
PFT_BOOL PFunc_GetModifiedFlg()
{
	bool f = m_TaEditShell->GetDocument()->GetIsModify();
	return f ? PFT_TRUE : PFT_FALSE;
}
