////////////////////////////////////////////////////////////////////////////
// CSemaphore 饹Υץơ
//
////////////////////////////////////////////////////////////////////////////

#include <assert.h>
#include <errno.h>
#include <time.h>
#include "Semaphore.h"

////////////////////////////////////////////////////////////////////////////
// /˴
////////////////////////////////////////////////////////////////////////////

CSemaphore::CSemaphore( int argMaxCount )
{
	MaxCount = argMaxCount;
	assert( !sema_init( &m_Semaphore, argMaxCount, USYNC_THREAD, NULL ) );
}

CSemaphore::~CSemaphore()
{
	assert( !sema_destroy( &m_Semaphore ) );
}

////////////////////////////////////////////////////////////////////////////
// ᥽å
////////////////////////////////////////////////////////////////////////////

// 
void CSemaphore::P()
{
	assert( !sema_wait( &m_Semaphore ) );
}

// 
void CSemaphore::V()
{
	assert( !sema_post( &m_Semaphore ) );
}

// ͭʤͭ
// ͭ褿鿿֤
bool CSemaphore::Try()
{
	int r = sema_trywait( &m_Semaphore );
	switch ( r ) {
	case 0:
		return true;
	case EBUSY:
		return false;
	}
	assert( false );
}

// Ԥ֤ꤷԤ碌
bool CSemaphore::WaitForTime( int ms )
{
	// 100msñ̤TryԤ
	// ms֤Ԥ碌

	struct timespec req;
	int cnt = ms / 100;	// TryԤ
	int i;

	// 100msñ̤TryԤ
	req.tv_sec = 0;
	req.tv_nsec = 100 * 1000 * 1000;

	for ( i = 0; i < cnt; i++ ) {
		// 100msԤ碌
		if( nanosleep( &req, NULL ) ) return false;
		// ͭߤ
		if ( Try() ) return true;
	}

	// 100msξ;֤Ԥ碌
	req.tv_nsec = ( ms % 100 ) * 1000 * 1000;
	if( nanosleep( &req, NULL ) ) return false;

	// Ǹ˰ͭߤ
	return Try();
}

