////////////////////////////////////////////////////////////////////////////
// CTaEditDoc 饹Υץơ
//
////////////////////////////////////////////////////////////////////////////

#include "TaEditDoc.h"
#include "TaEditShell.h"
#include <sys/stat.h>
#include <X11/keysym.h>


////////////////////////////////////////////////////////////////////////////
// /˴
////////////////////////////////////////////////////////////////////////////

CTaEditDoc::CTaEditDoc() :
	IsModify( false ), pTxtColorMgr( NULL )
{
	FileName = "";
	UndoListMgr.Clear();
}

CTaEditDoc::~CTaEditDoc()
{

}

////////////////////////////////////////////////////////////////////////////
// ᥽å
////////////////////////////////////////////////////////////////////////////

// եɤ߹
// ɥȤƤѹäpIsChanged˿֤
CErrorBool CTaEditDoc::OnOpenDocument( const string &argFileName, bool *pIsChanged ) 
{
	assert( NULL != this && NULL != pIsChanged );

	wchar_t wc[ TA_MAX_LINE_SIZE + 1 ];
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();
	bool NewLineFlg; // Ǹɤ߹Ԥ˲ԥɤޤޤƤݤݻ
	CErrorBool r;
	(*pIsChanged) = false;

	// եξ֤ǧ
	r = CheckFileStatus( argFileName, true );
	if ( !r ) return r;

	// եΥץ
	FILE *infile = fopen( argFileName.c_str(), "r" );
	if ( NULL == infile ) return CErrorBool( pConf->RefFaultFileOpenMsg() );

	vecLine.clear();	// ǡ򥯥ꥢ
	UndoListMgr.Clear();	// UndoꥹȤ˴롣
	IsModify = false;	// ե饰򤪤
	(*pIsChanged) = true;
	while ( !feof( infile ) && !ferror( infile ) ) {

		// ɤ߹
		if ( !fgetws( wc, TA_MAX_LINE_SIZE + 1, infile ) ) break;

		size_t wc_len = wslen( wc );	// ʸĹ

		// ɤ߹Ԥ˲ԥɤĤƤ뤫ݤ
		if ( L'\n' == wc[ wc_len - 1 ] ) {
			wc[ wc_len - 1 ] = L'\0';	// ԥɤĤƤ
			NewLineFlg = true;		// ե饰ꤹ
			wc_len--;
		}
		else
			NewLineFlg = false;

		// ԤĹγǧ
		if ( wc_len >= TA_MAX_LINE_SIZE ) {
			r = CErrorBool( pConf->RefBrokenLineMsg() );
			break;
		}

		// ꥹȤ˹Ԥɲ
		vecLine.push_back( wc );
	}
	if ( ferror( infile ) ) 
		r = CErrorBool( pConf->RefIOErrorMsg( errno ) );

	// Ǹɤ߹Ԥ˲ԥɤޤޤƤ硢
	// ⤷ϰԤɤ߹Ǥʤˤ
	// ιԤդäɬפ
	if ( NewLineFlg || vecLine.size() == 0 ) vecLine.push_back( L"" );

	fclose( infile );

	if ( r ) {
		FileName = argFileName;	// ե̾
		UpdateTextColorMgr();	// ¸󥪥֥Ȥ򹹿
	}
	else
		Initialize();	// Ԥ顢ե̾ɤ߹Ƥ˴

	return r;
}

// եν
CErrorBool CTaEditDoc::OnSaveDocument( const string &argFileName ) 
{
	T_LineDataItr_c itr;
	T_LineDataItr_c itrLastLine;	// ǸιԤݥ
	size_t i;
	CErrorBool r;
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();
	string BeforeFileName = FileName;

	assert( vecLine.size() > 0 );

	// եξ֤ǧʥե뤬¸ߤɬפϤʤ
	r = CheckFileStatus( argFileName, false );
	if ( !r ) return r;

	// ե򳫤
	FILE *outfile = fopen( argFileName.c_str(), "w" );
	if ( NULL == outfile ) return CErrorBool( pConf->RefFaultFileOpenMsg() );

	// ǸιԤݥȤ륤ƥ졼
	itrLastLine = vecLine.end();
	--itrLastLine;

	for ( itr = vecLine.begin(); itr != vecLine.end() && !ferror( outfile ); itr++ ) {
		// ԤĽϤ
		fputws( itr->getString().c_str(), outfile );
		// ʺǸιԤˤϲԥɤϤʤ
		if ( itr != itrLastLine ) putwc( L'\n', outfile );
	}

	if ( ferror( outfile ) ) r = pConf->RefIOErrorMsg( errno );
	fclose( outfile );
	if ( !r ) return r;

	// ե¸顢ɥȤΥե̾ꤹ롣
	FileName = argFileName;
	IsModify = false;	// ե饰򤪤

	// ¸󥪥֥Ȥ򹹿
	UpdateTextColorMgr();

	return true;
}

// ե̾λ
const string& CTaEditDoc::GetFileName() const
{
	return FileName;
}

// 
void CTaEditDoc::Initialize()
{
	CLineData dummy;

	vecLine.clear();
	FileName = "";

	UndoListMgr.Clear();	// ɥꥹȤ򥯥ꥢ
	UndoListMgr.SetMaxUndoCount( m_TaEditShell->GetConfigInfo()->GetMaxUndoCount() );

	IsModify = false;	// ե饰򤪤
	vecLine.push_back( dummy );	// ιԤϿ

	// ¸󥪥֥Ȥ򹹿
	UpdateTextColorMgr();
}

// ʸ
CErrorBool CTaEditDoc::Insert( const wstring& rStr, const T_CurPos &rCurPos, const T_SelRange &rSelRange, T_CurPos *pResultCurPos )
{
	T_CurPos wCurPos = rCurPos;
	int i;
	int LineCnt, CharCnt;
	VClsPtr< CEditCommand > wpEditCommand;
	CErrorBool r;

	(*pResultCurPos) = rCurPos;
	if ( vecLine.size() <= rCurPos.GetLine() ) return true;
	IsModify = true;	// ե饰򤿤Ƥ

	// 򤵤ƤϰϤ
	if ( rSelRange.GetLength() > T_CurPos( 0, 0 ) ) {
		r = Delete_WithCreateEC( rSelRange, rCurPos );
		if ( !r ) return r;
		wCurPos = rSelRange.GetSPos();
		(*pResultCurPos) = wCurPos;
	}

	// ԤĹǧ
	CharCnt = wCurPos.GetCPos();
	LineCnt = 0;
	for ( i = 0; i < rStr.length(); i++ ) {
		CharCnt++;
		if ( CharCnt >= TA_MAX_LINE_SIZE )
			return CErrorBool( m_TaEditShell->GetConfigInfo()->RefBrokenLineMsg() );
		if ( rStr[i] == L'\n' ) {
			CharCnt = 0;
			LineCnt++;
		}
	}
	// ʤλLineCntˤɲäԤιԿ-1
	// CharCntˤϺǸιԤɲäʸǼƤ롣
	// ʤɲäǡԤäϡ֤Ȥʤ
	if ( CharCnt + vecLine[ wCurPos.GetLine() ].length() - wCurPos.GetCPos() >= TA_MAX_LINE_SIZE )
		return CErrorBool( m_TaEditShell->GetConfigInfo()->RefBrokenLineMsg() );

	// ͤ
	T_CurPos RetACPT( wCurPos.GetLine() + LineCnt, CharCnt );

	// Խޥɥ֥Ȥ
	wpEditCommand = CreateEditCommandObj( TEC_INSERT );
	if ( NULL != wpEditCommand ) {
		if ( rSelRange.GetLength() > T_CurPos( 0, 0 ) )
			wpEditCommand->SetCurPos_SelRange( rSelRange, wCurPos, T_SelRange( RetACPT, RetACPT ), RetACPT );
		else {
			T_SelRange ws = T_SelRange( wCurPos, wCurPos );
			wpEditCommand->SetCurPos_SelRange( ws, wCurPos, T_SelRange( RetACPT, RetACPT ), RetACPT );
		}
		wpEditCommand->SelInsertInfo( wCurPos, rStr );
		UndoListMgr.PushBack( wpEditCommand );
	}

	// ʸ
	InsertSpecifiedStr( wCurPos, rStr );

	(*pResultCurPos) = RetACPT;
	return true;
}

// ü쵭
// pResultCurPos˥ꤹ٤֤֤
CErrorBool CTaEditDoc::InsertSpecialCode( KeySym argKeySym, const T_CurPos &rCurPos, const T_SelRange &rSelRange, T_CurPos *pResultCurPos )
{
	int i;
	VClsPtr< CEditCommand > wpEditCommand;
	const int cpos = rCurPos.GetCPos();
	const int line = rCurPos.GetLine();
	T_CurPos RetACPT;
	T_CurPos wpos;
	CErrorBool r;

	IsModify = true;	// ե饰򤿤Ƥ
	(*pResultCurPos) = rCurPos;

	// ϰ򤵤Ƥ
	if ( rSelRange.GetLength() > T_CurPos( 0, 0 ) ) {
		// 򤵤ƤϰϤ
		r = Delete_WithCreateEC( rSelRange, rCurPos );
		if ( !r ) return r;

		// BackSpaceDeleteä
		if ( argKeySym == XK_BackSpace || argKeySym == XK_Delete ) {
			// ϰϤƬͤȤơλ
			(*pResultCurPos) = rSelRange.GetSPos();
			return true;
		}
	}

	switch ( argKeySym ) {
	case XK_BackSpace:
		if ( cpos <= 0 && line <= 0 ) return true;// Ǥʤ
		if ( 0 == cpos )
			// ԤƬäϡιԤ鸽ߤιԤƬޤǤ
			RetACPT = T_CurPos( line - 1, vecLine[ line - 1 ].length() );
		else
			// ʸ
			RetACPT = T_CurPos( line, cpos - 1 );
		(*pResultCurPos) = RetACPT;
		return Delete_WithCreateEC( T_SelRange( RetACPT, rCurPos ), rCurPos );

	case XK_Delete:
		if ( line >= vecLine.size() - 1 && cpos >= vecLine[ line ].length() )
			return true;	// Ǥʤ
		RetACPT = rCurPos;
		if ( cpos == vecLine[ line ].length() )
			// Ԥäϡ֤߰鼡ιԤƬޤǤ
			wpos = T_CurPos( line + 1, 0 );
		else
			// ߻ؤƤʸ
			wpos = T_CurPos( line, cpos + 1 );
		return Delete_WithCreateEC( T_SelRange( rCurPos, wpos ), rCurPos );

	case XK_KP_Enter:
	case XK_Return:
		RetACPT = T_CurPos( rSelRange.GetSPos().GetLine() + 1, 0 );
		(*pResultCurPos) = RetACPT;

		// Խޥɥ֥Ȥۤ
		wpEditCommand = CreateEditCommandObj( TEC_INSERT );
		if ( NULL != wpEditCommand ) {
			if ( rSelRange.GetLength() > T_CurPos( 0, 0 ) ) {
				// ʸ󤬺Ƥ
				T_CurPos wc = rSelRange.GetSPos();
				T_SelRange ws = T_SelRange( wc, wc );
				wpEditCommand->SetCurPos_SelRange( ws, wc, T_SelRange( RetACPT, RetACPT ), RetACPT );
				wpEditCommand->SelInsertInfo( wc, L"\n" );
			}
			else {
				// Ƥʤ
				wpEditCommand->SetCurPos_SelRange( rSelRange, rCurPos, T_SelRange( RetACPT, RetACPT ), RetACPT );
				wpEditCommand->SelInsertInfo( rCurPos, L"\n" );
			}
			UndoListMgr.PushBack( wpEditCommand );
		}
		InsertSpecifiedStr( rSelRange.GetSPos(), L"\n" );
		pResultCurPos->SetCPos( ExecAutoIndent( rSelRange.GetSPos().GetLine() ) );
		return true;
	}
	return CErrorBool( m_TaEditShell->GetConfigInfo()->RefUnexpectedErrorMsg() );
}

// ʣԤؤTAB
CErrorBool CTaEditDoc::MultiLineTabInsert( const T_SelRange &rSelRange, T_CurPos *pResultCurPos, T_SelRange *pResultSelRange )
{
	int sl = rSelRange.GetSPos().GetLine();
	int el = rSelRange.GetEPos().GetLine();
	int i;
	T_CurPos dummyCurPos;
	T_CurPos wCurPos;
	T_SelRange wSelRange;
	CErrorBool r;
	const wstring &rStr = m_TaEditShell->GetConfigInfo()->RefTabString();

	// 򤵤Ƥ롢ƹԤιƬTABʸ
	for ( i = sl; i <= el; i++ ) {
		wCurPos = T_CurPos( i, 0 );
		wSelRange = T_SelRange( wCurPos, wCurPos );
		r = Insert( rStr, wCurPos, wSelRange, &dummyCurPos );
		if ( !r ) return r;
	}

	// ϰϤTABʸԤäΤȤ롣
	(*pResultCurPos) = T_CurPos( el, vecLine[ el ].length() );
	(*pResultSelRange) = T_SelRange( T_CurPos( sl, 0 ), (*pResultCurPos) );
	return true;
}

// ʣԤTABκ
CErrorBool CTaEditDoc::MultiLineTabDelete( const T_SelRange &rSelRange, T_CurPos *pResultCurPos, T_SelRange *pResultSelRange )
{
	int sl = rSelRange.GetSPos().GetLine();
	int el = rSelRange.GetEPos().GetLine();
	int i;
	T_CurPos wCurPos;
	T_SelRange wSelRange;
	CErrorBool r;
	const wstring &rStr = m_TaEditShell->GetConfigInfo()->RefTabString();

	// 򤵤Ƥ롢ƹԤιƬ¸ߤTABʸ
	for ( i = sl; i <= el; i++ ) {
		wCurPos = T_CurPos( i, 0 );
		// ƬTABʸʤСԤʤ
		if ( wsncmp( vecLine[i].getString().c_str(), rStr.c_str(), rStr.length() ) == 0 ) {
			wSelRange = T_SelRange( T_CurPos( i, 0 ), T_CurPos( i, rStr.length() ) );
			r = Delete_WithCreateEC( wSelRange, wCurPos );
			if ( !r ) return r;
		}
	}

	// ϰϤTABʸκԤäΤȤ롣
	(*pResultCurPos) = T_CurPos( el, vecLine[ el ].length() );
	(*pResultSelRange) = T_SelRange( T_CurPos( sl, 0 ), (*pResultCurPos) );
	return true;
}

// Խޥɥ֥ȤơʸκԤ
CErrorBool CTaEditDoc::Delete_WithCreateEC( T_SelRange DelRange, T_CurPos BeforeCurPos )
{
	VClsPtr< CEditCommand > wpEditCommand;
	CErrorBool r;

	// ϰϤʸ
	wstring wDelStr;
	GetRangeStr( DelRange, &wDelStr );

	// ʸ
	r = Delete( DelRange );
	if ( !r ) return r;

	// Խޥɥ֥Ȥۤ
	wpEditCommand = CreateEditCommandObj( TEC_DELETE );
	if ( NULL != wpEditCommand ) {
		T_CurPos wc = DelRange.GetSPos();
		wpEditCommand->SetCurPos_SelRange( DelRange, BeforeCurPos, T_SelRange( wc, wc ), wc );
		wpEditCommand->SetDeleteInfo( DelRange, wDelStr );
		UndoListMgr.PushBack( wpEditCommand );
	}
	return true;
}

// ǡλ
const T_LineData& CTaEditDoc::RefData() const
{
	return vecLine;
}

// ե饰
bool CTaEditDoc::GetIsModify() const
{
	return IsModify;
}

// ɥǽݤ
bool CTaEditDoc::EnableUndo() const
{
	return UndoListMgr.EnableUndo();
}

// ɥǽݤ
bool CTaEditDoc::EnableRedo() const
{
	return UndoListMgr.EnableRedo();
}

// ɥ
void CTaEditDoc::Undo( T_SelRange *pAfterUndoSelRange, T_CurPos *pAfterUndoCurPos )
{
	assert( NULL != pAfterUndoSelRange && NULL != pAfterUndoCurPos );
	if ( !EnableUndo() ) return ;

	const VClsPtr< CEditCommand > pEC = UndoListMgr.GetUndoObj();

	// ɥϰϤȥ֤
	(*pAfterUndoSelRange) = pEC->GetBeforeSelRange();
	(*pAfterUndoCurPos) = pEC->GetBeforeCurPos();

	if ( pEC->GetType() == TEC_INSERT ) {
		// ʸԤƤ
		// 줿ʸ
		DelSpecifiedStr( pEC->GetInsertPos(), pEC->GetInsertText() );
	}
	else {
		// ʸκԤƤ
		// 줿ʸ
		InsertSpecifiedStr( pEC->GetDeleteRange().GetSPos(), pEC->GetDeleteText() );
	}
}

// ɥ
void CTaEditDoc::Redo( T_SelRange *pAfterRedoSelRange, T_CurPos *pAfterRedoCurPos )
{
	assert( NULL != pAfterRedoSelRange && NULL != pAfterRedoCurPos );
	if ( !EnableRedo() ) return ;

	const VClsPtr< CEditCommand > pEC = UndoListMgr.GetRedoObj();

	// ɥϰϤȥ֤
	(*pAfterRedoSelRange) = pEC->GetAfterSelRange();
	(*pAfterRedoCurPos) = pEC->GetAfterCurPos();

	if ( pEC->GetType() == TEC_INSERT ) {
		// ʸԤƤ
		// 줿ʸ򡢺
		InsertSpecifiedStr( pEC->GetInsertPos(), pEC->GetInsertText() );
	}
	else {
		// ʸκԤƤ
		// 줿ʸ򡢺ٺ
		Delete( pEC->GetDeleteRange() );
	}
}

// ꤷ֤¸ߤ롢ꤷʸ
// ʺֵڤӺ줿ƥȤȽ뤬줿ϰϤξ󤬼Ƥ˻ѡ
CErrorBool CTaEditDoc::DelSpecifiedStr( T_CurPos pos, const wstring &rStr )
{
	T_SelRange wSelRange;	// ʸϰϤݻ
	T_CurPos wSelRange_end;		// wSelRangeνλ֤η׻
	int crcnt = 0;
	int i;

	// ʸ˴ޤޤƤԥɤο򻻽
	for ( i = 0; i < rStr.length(); i++ ) {
		if ( rStr[i] == L'\n' ) crcnt++;
	}

	// ʸϰϤ
	if ( crcnt == 0 ) {
		// ʸ˲ԥɤޤޤƤʤ
		wSelRange_end.SetLine( pos.GetLine() );
		wSelRange_end.SetCPos( pos.GetCPos() + rStr.length() );
	}
	else {
		// ʸ˲ԥɤޤޤƤ
		wSelRange_end.SetLine( pos.GetLine() + crcnt );
		wSelRange_end.SetCPos( rStr.length() - rStr.rfind( L'\n' ) - 1 );
	}

	// ʸ
	wSelRange.SetPosEx( pos, wSelRange_end );
	return Delete( wSelRange );
}

// ꤷ֤˻ꤷʸʲԥɤޤˤɲä
void CTaEditDoc::InsertSpecifiedStr( T_CurPos pos, const wstring &rStr )
{
	int i;	// rStrν֤ݻ
	int j;
	int h;	// iΰͤݻ
	int p = pos.GetCPos();
	int wLine = pos.GetLine();

	i = 0;
	h = 0;
	while ( i < rStr.length() ) {
		// ԥɤ򸡺
		while ( i < rStr.length() && rStr[i] != L'\n' ) i++;
		// ʸ
		vecLine[ wLine ].InsertBlank( p, i - h );
		for ( j = 0; j < ( i - h ); j++ )
			vecLine[ wLine ].set( p + j, TA_CHAR( rStr[ h + j ], 0 ) );
		// оݤʸãƤʤСԤɲä
		if ( i >= rStr.length() ) {
			break;
		}
		AddCR( T_CurPos( wLine, p + j ) );	// ιԤˤ硢rStr[i]ϲԥɤǤ
		p = 0;
		i++;	// ʸ
		h = i;
		wLine++;
	}
// printf( "%d %d : %d\n", wLine, pos.GetLine(), i - h );
	// ʸĴɽԤ
	if ( pTxtColorMgr ) {
		T_SelRange sr;
		if ( wLine == pos.GetLine() )
			sr = T_SelRange( pos, T_CurPos( wLine, pos.GetCPos() + rStr.length() ) );
		else
			sr = T_SelRange( pos, T_CurPos( wLine, i - h ) );
		pTxtColorMgr->Update( vecLine, sr );
	}
}

// 
void CTaEditDoc::AddCR( T_CurPos pos )
{
	CLineData w;
	int i, j;
	int cLine = pos.GetLine();
	int nLine = cLine + 1;
	int xPos = pos.GetCPos();
	CLineData *wpLine;

	// ιԤɲä
	vecLine.insert( vecLine.begin() + nLine, w );	

	// ιԤˤ롢ԥɤο
	// ɲäԤꤹ
	wpLine = &( vecLine[ cLine ] );
	vecLine[ nLine ].setIro( 0, wpLine->getIro( wpLine->length() ) );

	// ɲäιԤˡʸϿ
	j = vecLine[ cLine ].length() - xPos;	// ɲäԤϿʸ

	if ( j <= 0 ) return ;
	wpLine = &( vecLine[ nLine ] );
	wpLine->InsertBlank( 0, j );	// ΰ
	for ( i = 0; i < j; i++ )	// ʸ
		wpLine->set( i, vecLine[ cLine ][ i + xPos ] );

	// Ԥ˰ܤʬʸ
	vecLine[ cLine ].Delete( xPos, xPos + j );
}

// ưǥȤˤĴ
// lineιԤƬˤʤɤline+1ιƬ
// ʸ֤
int CTaEditDoc::ExecAutoIndent( int line )
{
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();
	bool AutoIndent = pConf->GetAutoIndent();
	const wstring &IndentChar = pConf->RefIndentChar();
	int i, j;

	assert( this && line < vecLine.size() - 1 );
	
	CLineData *wpLine1 = &( vecLine[ line ] );
	CLineData *wpLine2 = &( vecLine[ line + 1 ] );

	if ( !AutoIndent ) return 0;	// ȥǥȤɬפʤнλ

	// ǥȤʸ򥫥
	for ( i = 0; i < wpLine1->length() && NULL != wcschr( IndentChar.c_str(), (*wpLine1)[i].moji ); ++i );

	wpLine2->InsertBlank( 0, i );	// ΰ
	for ( j = 0; j < i; ++j )	// ʸ
		wpLine2->set( j, (*wpLine1)[j] );

	// ʸĴɽԤ
	if ( pTxtColorMgr )
		pTxtColorMgr->Update( vecLine, T_SelRange( T_CurPos( line + 1, 0 ), T_CurPos( line + 1, i ) ) );

	return i;
}

// ʸκ
CErrorBool CTaEditDoc::Delete( const T_SelRange &rRange )
{
	assert( NULL != this );

	int sline = rRange.GetSPos().GetLine();
	int scpos = rRange.GetSPos().GetCPos();
	int eline = rRange.GetEPos().GetLine();
	int ecpos = rRange.GetEPos().GetCPos();

	assert( sline >= 0 && sline < vecLine.size() && eline >= 0 && eline < vecLine.size() );

	int sLineLength = vecLine[ sline ].length();
	int eLineLength = vecLine[ eline ].length();

	assert( scpos >= 0 && scpos <= sLineLength && ecpos >= 0 && ecpos <= eLineLength );

	if ( sline == eline ) {
		// Ʊΰ
		vecLine[ sline ].Delete( scpos, ecpos );

		// ʸĴɽԤ
		if ( pTxtColorMgr ) {
			T_SelRange sr = T_SelRange( rRange.GetSPos(), rRange.GetSPos() );
			pTxtColorMgr->Update( vecLine, sr );
		}

		return true;
	}

	// ԤĹФå
	if ( scpos + ( eLineLength - ecpos ) >= TA_MAX_LINE_SIZE ) {
		VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();
		return CErrorBool( pConf->RefBrokenLineMsg() );
	}

	// 򳫻ϤԤФ
	vecLine[ sline ].Delete( scpos, sLineLength );

	// ιԤƺ
	vecLine.erase( vecLine.begin() + sline + 1, vecLine.begin() + eline );

	// Ϣ
	vecLine[ sline ].InsertBlank( scpos, ( eLineLength - ecpos ) );
	for ( int i = 0; i < eLineLength - ecpos; i++ )
		vecLine[ sline ].set( i + scpos, vecLine[ sline + 1 ][ i + ecpos ] );
	// ʲԥɤοϢ뤹
	unsigned char col = vecLine[ sline + 1 ].getIro( vecLine[ sline + 1 ].length() );
	vecLine[ sline ].setIro( vecLine[ sline ].length(), col );

	// ϰϤκǸιԤ
	vecLine.erase( vecLine.begin() + sline + 1 );

	// ʸĴɽԤ
	if ( pTxtColorMgr )
		pTxtColorMgr->Update( vecLine, T_SelRange( rRange.GetSPos(), rRange.GetSPos() ) );

	return true;
}

// Խޥɥ֥Ȥ
VClsPtr< CEditCommand > CTaEditDoc::CreateEditCommandObj( enumTEC_TYPE argType )
{
	// ʤ

	VClsPtr< CEditCommand > wpEditCommand = new CEditCommand( argType );
	if ( NULL == wpEditCommand ) 
		UndoListMgr.Clear();	// ꤬­ϡɥꥹȤ˴
	return wpEditCommand;
}


// ꤷϰϤʸ
void CTaEditDoc::GetRangeStr( const T_SelRange &range, wstring *pStr )
{
	const T_CurPos s = range.GetSPos();
	const T_CurPos e = range.GetEPos();
	int i;
	size_t wLen;

	// ƱιԤꤵ줿
	if ( s.GetLine() == e.GetLine() ) {
		if ( s.GetCPos() == e.GetCPos() ) {
			(*pStr) = L"";	// ֤٤ʸϤʤ
			return ;
		}
		const wstring &wrstr = vecLine[ s.GetLine() ].getString();
		(*pStr) = wrstr.substr( s.GetCPos(), e.GetCPos() - s.GetCPos() );
		return ;
	}

	// ǽιԤʸ
	int sline = s.GetLine();
	int eline = e.GetLine();
	(*pStr) = vecLine[ sline ].getString().substr( s.GetCPos() );

	// ֤ιԤʸ
	// ɬפȤʤʸ򥫥ȡ
	wLen = 0;
	i = sline;
	for ( i++; i != eline; i++ )
		wLen += 1 + vecLine[ sline ].getString().length();
	// ΰ
	pStr->reserve( pStr->length() + wLen );
	// 
	for ( sline++; sline != eline; sline++ ) {
		(*pStr) += wstring( L"\n" ) + vecLine[ sline ].getString();
	}

	// ǸιԤʸ
	(*pStr) += wstring( L"\n" ) + vecLine[ sline ].getString().substr( 0, e.GetCPos() );
}

// եξ֤ǧ
CErrorBool CTaEditDoc::CheckFileStatus( const string &rFileName, bool Exist )
{
	struct stat StatusInfo;
	int r;
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();

	r = lstat( rFileName.c_str(), &StatusInfo );
	if ( -1 == r ) {
		// ե뤬¸ߤʤ
		if ( !Exist )
			return true;	// ¸ߤɬפʤС֤
		return CErrorBool( pConf->RefFileIsNotExistMsg() );
	}

	if ( StatusInfo.st_mode & S_IFDIR )
		return CErrorBool( pConf->RefSpecifiedNameIsDirMsg() );

	return true;
}

// ¸󥪥֥Ȥ
const NLangExt::CTxtColorMgr* CTaEditDoc::GetTxtColorMgr() const
{
	return pTxtColorMgr;
}

// ¸󥪥֥Ȥ򹹿
void CTaEditDoc::UpdateTextColorMgr()
{
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();
	const NLangExt::CLangConfig *pLangConf = m_TaEditShell->GetLangConfig();

	// pLangConfNULLβǽ
	if ( NULL == pLangConf ) return ;

	// ⡼ɤͭˤʤ롢եκĹ
	unsigned int LangTypeEnableMaxSize = pConf->GetLangTypeEnableMaxSize();

	// ʸĹ򻻽Ф
	unsigned long size = 0;
	T_LineDataItr_c itr = vecLine.begin();
	for ( ; itr != vecLine.end(); ++itr )
		size += itr->length() + 1;

	// 
	if ( size < LangTypeEnableMaxSize )
		SetTxtColorMgr( pLangConf->GetLangTypeID( FileName.c_str() ) );
	else
		SetTxtColorMgr( LANGTYPE_TEXT );
}

// 󥪥֥Ȥ
// κ꤬Ԥ줿ˤϿ֤
bool CTaEditDoc::SetTxtColorMgr( enumLANGTYPE type )
{
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();
	const NLangExt::CLangConfig *pLangConf = m_TaEditShell->GetLangConfig();

	// pLangConfNULLβǽ
	if ( NULL == pLangConf ) return false;

	if ( pTxtColorMgr ) {
		// ¸ΤΤ¸ߤ
		if ( pTxtColorMgr->GetLangType() != type ) {
			// 󥪥֥Ȥ򹹿ʤƤϤʤʤϡ¸ΤΤ˴
			delete pTxtColorMgr;
			pTxtColorMgr = NULL;
		}
	}

	if ( !pTxtColorMgr ) {
		// 	󥪥֥Ȥۤ
		pTxtColorMgr = pLangConf->CreateColorMgr( type );
		if ( NULL == pTxtColorMgr ) return false;

		// 󥪥֥Ȥ
		if ( !pTxtColorMgr->Initialize( pConf ) ) {
			delete pTxtColorMgr;
			pTxtColorMgr = NULL;
			return false;
		}
	}

	// ʸĴɽԤ
	pTxtColorMgr->InitiUpdate( vecLine );

	return true;
}

