////////////////////////////////////////////////////////////////////////////
// TimeSpec.h
// CTimeSpec饹Υץơ
//
// timespec¤ΤФ黻
////////////////////////////////////////////////////////////////////////////

#if !defined( TIMESPEC_H_INCLUDED_ )
#define TIMESPEC_H_INCLUDED_

#include <time.h>

class CTimeSpec : public timespec
{
public:
	CTimeSpec(){
		tv_sec = 0;
		tv_nsec = 0;
	};
	CTimeSpec( const struct timespec &r ) {
		tv_sec = r.tv_sec;
		tv_nsec = r.tv_nsec;
	};
	CTimeSpec( const double d ) {
		tv_sec = (int)d;
		tv_nsec = (int)( d - tv_sec * 1000000000.0 );
	}

/*
	operator (timespec)() const {
		timespec w = { timespec::tv_sec, timespec::tv_nsec };
		return w;
	};
*/

	bool operator >( const struct timespec &r ) const {
		if ( timespec::tv_sec > r.tv_sec )
			return true;
		if ( timespec::tv_nsec > r.tv_nsec )
			return true;
		return false;
	};
	bool operator <( const struct timespec &r ) const {
		return CTimeSpec( r ) > (*this);
	}

	bool operator ==( const struct timespec &r ) const {
		return ( timespec::tv_sec == r.tv_sec && timespec::tv_nsec == r.tv_nsec );
	};

	bool operator !=( const struct timespec &r ) const {
		return !( operator ==( r ) );
	};

	const CTimeSpec& operator =( const struct timespec &r ) {
		timespec::tv_sec = r.tv_sec;
		timespec::tv_nsec = r.tv_nsec;
		return (*this);
	};

	CTimeSpec operator +( const struct timespec &r ) {
		CTimeSpec w;
		w.tv_sec = timespec::tv_sec + r.tv_sec;
		w.tv_nsec = timespec::tv_nsec + r.tv_nsec;
		if ( w.tv_nsec >= 1000000000 ) {
			w.tv_nsec -= 1000000000;
			w.tv_sec += 1;
		}
		return w;
	};
	CTimeSpec operator -( const struct timespec &r ) {
		CTimeSpec w;
		if ( timespec::tv_nsec > r.tv_nsec ) {
			w.tv_sec = timespec::tv_sec - r.tv_sec;
			w.tv_nsec = timespec::tv_nsec - r.tv_nsec;
		}
		else {
			w.tv_sec = timespec::tv_sec - r.tv_sec - 1;
			w.tv_nsec = timespec::tv_nsec + 1000000000 - r.tv_nsec;
		}
		return w;
	};
};

#endif // TIMESPEC_H_INCLUDED_
